/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import wayoftime.bloodmagic.client.key.IKeybindable;
import wayoftime.bloodmagic.client.key.KeyBindings;

public class KeyProcessorPacket {
    public int keyId;
    public boolean showInChat;

    public KeyProcessorPacket(int keyId, boolean showInChat) {
        this.keyId = keyId;
        this.showInChat = showInChat;
    }

    public KeyProcessorPacket(KeyBindings key, boolean showInChat) {
        this(key.ordinal(), showInChat);
    }

    public static void encode(KeyProcessorPacket pkt, FriendlyByteBuf buf) {
        buf.writeInt(pkt.keyId);
        buf.writeBoolean(pkt.showInChat);
    }

    public static KeyProcessorPacket decode(FriendlyByteBuf buf) {
        KeyProcessorPacket pkt = new KeyProcessorPacket(buf.readInt(), buf.readBoolean());
        return pkt;
    }

    public static void handle(KeyProcessorPacket message, Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> KeyProcessorPacket.sendKeyToServer(message, (Player)((NetworkEvent.Context)context.get()).getSender()));
        context.get().setPacketHandled(true);
    }

    public static void sendKeyToServer(KeyProcessorPacket msg, Player playerEntity) {
        ItemStack heldStack;
        if (playerEntity != null && (heldStack = playerEntity.m_21205_()).m_41720_() instanceof IKeybindable) {
            if (msg.keyId < 0 || msg.keyId >= KeyBindings.values().length) {
                return;
            }
            KeyBindings key = KeyBindings.values()[msg.keyId];
            ((IKeybindable)heldStack.m_41720_()).onKeyPressed(heldStack, playerEntity, key, msg.showInChat);
        }
    }
}

