/*
 * Decompiled with CFR 0.152.
 */
package wayoftime.bloodmagic.common.data.recipe.builder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.commons.lang3.tuple.Pair;
import wayoftime.bloodmagic.common.data.recipe.BloodMagicRecipeBuilder;
import wayoftime.bloodmagic.potion.BloodMagicPotions;

public class PotionTransformRecipeBuilder
extends BloodMagicRecipeBuilder<PotionTransformRecipeBuilder> {
    private final List<Ingredient> input;
    private final List<Pair<MobEffect, Integer>> outputEffectList;
    private final List<MobEffect> inputEffectList;
    private final int syphon;
    private final int ticks;
    private final int minimumTier;

    protected PotionTransformRecipeBuilder(List<Ingredient> input, MobEffect outputEffect, int baseDuration, MobEffect inputEffect, int syphon, int ticks, int minimumTier) {
        this(input, new ArrayList<Pair<MobEffect, Integer>>(), new ArrayList<MobEffect>(), syphon, ticks, minimumTier);
        this.outputEffectList.add((Pair<MobEffect, Integer>)Pair.of((Object)outputEffect, (Object)baseDuration));
        this.addInputEffect(inputEffect);
    }

    protected PotionTransformRecipeBuilder(List<Ingredient> input, List<Pair<MobEffect, Integer>> outputEffectList, List<MobEffect> inputEffectList, int syphon, int ticks, int minimumTier) {
        super(PotionTransformRecipeBuilder.bmSerializer("flask_potiontransform"));
        this.outputEffectList = outputEffectList;
        this.inputEffectList = inputEffectList;
        this.input = input;
        this.syphon = syphon;
        this.ticks = ticks;
        this.minimumTier = minimumTier;
    }

    public static PotionTransformRecipeBuilder potionTransform(MobEffect outputEffect, int baseDuration, MobEffect inputEffect, int syphon, int ticks, int minimumTier) {
        ArrayList<Ingredient> inputList = new ArrayList<Ingredient>();
        return new PotionTransformRecipeBuilder(inputList, outputEffect, baseDuration, inputEffect, syphon, ticks, minimumTier);
    }

    public PotionTransformRecipeBuilder addIngredient(Ingredient ing) {
        if (this.input.size() < 5) {
            this.input.add(ing);
        }
        return this;
    }

    public PotionTransformRecipeBuilder addInputEffect(MobEffect effect) {
        if (!this.inputEffectList.contains(effect)) {
            this.inputEffectList.add(effect);
        }
        return this;
    }

    @Override
    protected PotionTransformRecipeResult getResult(ResourceLocation id) {
        return new PotionTransformRecipeResult(id);
    }

    public class PotionTransformRecipeResult
    extends BloodMagicRecipeBuilder.RecipeResult {
        protected PotionTransformRecipeResult(ResourceLocation id) {
            super(id);
        }

        public void m_7917_(@Nonnull JsonObject json) {
            JsonElement jsonObj;
            JsonArray mainArray;
            if (PotionTransformRecipeBuilder.this.input.size() > 0) {
                mainArray = new JsonArray();
                for (Ingredient ingredient : PotionTransformRecipeBuilder.this.input) {
                    jsonObj = ingredient.m_43942_();
                    mainArray.add(jsonObj);
                }
                json.add("input", (JsonElement)mainArray);
            }
            if (PotionTransformRecipeBuilder.this.outputEffectList.size() > 0) {
                mainArray = new JsonArray();
                for (Pair pair : PotionTransformRecipeBuilder.this.outputEffectList) {
                    jsonObj = new JsonObject();
                    jsonObj.addProperty("effect", BloodMagicPotions.getRegistryName((MobEffect)pair.getKey()).toString());
                    jsonObj.addProperty("baseDuration", (Number)pair.getValue());
                    mainArray.add(jsonObj);
                }
                json.add("outputEffect", (JsonElement)mainArray);
            }
            if (PotionTransformRecipeBuilder.this.inputEffectList.size() > 0) {
                mainArray = new JsonArray();
                for (int i = 0; i < PotionTransformRecipeBuilder.this.inputEffectList.size(); ++i) {
                    String string = BloodMagicPotions.getRegistryName(PotionTransformRecipeBuilder.this.inputEffectList.get(i)).toString();
                    mainArray.add(string);
                }
                json.add("inputEffect", (JsonElement)mainArray);
            }
            json.addProperty("syphon", (Number)PotionTransformRecipeBuilder.this.syphon);
            json.addProperty("ticks", (Number)PotionTransformRecipeBuilder.this.ticks);
            json.addProperty("upgradeLevel", (Number)PotionTransformRecipeBuilder.this.minimumTier);
        }
    }
}

