/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.foundation;

import cofh.thermal.core.ThermalCore;
import cofh.thermal.foundation.client.model.geom.ModelLayers;
import cofh.thermal.foundation.init.registries.TFndBlocks;
import cofh.thermal.foundation.init.registries.TFndEntities;
import cofh.thermal.foundation.init.registries.TFndItems;
import cofh.thermal.foundation.util.TFndProxy;
import cofh.thermal.foundation.util.TFndProxyClient;
import cofh.thermal.lib.util.ThermalFlags;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="thermal_foundation")
public class ThermalFoundation {
    public static final TFndProxy PROXY = (TFndProxy)DistExecutor.unsafeRunForDist(() -> TFndProxyClient::new, () -> TFndProxy::new);
    public static final BlockSetType BLOCK_SET_TYPE_RUBBERWOOD = BlockSetType.m_272115_((BlockSetType)new BlockSetType("thermal:rubberwood"));
    public static final WoodType WOOD_TYPE_RUBBERWOOD = WoodType.m_61844_((WoodType)new WoodType("thermal:rubberwood", BLOCK_SET_TYPE_RUBBERWOOD));

    public ThermalFoundation() {
        this.setFeatureFlags();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::entityLayerSetup);
        modEventBus.addListener(this::entityRendererSetup);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        TFndBlocks.register();
        TFndItems.register();
        TFndEntities.register();
    }

    private void setFeatureFlags() {
        ThermalFlags.setFlag((String)ThermalFlags.FLAG_RESOURCE_NITER, (boolean)true);
        ThermalFlags.setFlag((String)ThermalFlags.FLAG_RESOURCE_SULFUR, (boolean)true);
        ThermalFlags.setFlag((String)ThermalFlags.FLAG_RESOURCE_TIN, (boolean)true);
        ThermalFlags.setFlag((String)ThermalFlags.FLAG_RESOURCE_LEAD, (boolean)true);
        ThermalFlags.setFlag((String)ThermalFlags.FLAG_RESOURCE_SILVER, (boolean)true);
        ThermalFlags.setFlag((String)ThermalFlags.FLAG_RESOURCE_NICKEL, (boolean)true);
        ThermalFlags.setFlag((String)ThermalFlags.FLAG_RESOURCE_RUBBERWOOD, (boolean)true);
    }

    private void entityLayerSetup(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModelLayers.RUBBERWOOD_BOAT_LAYER, BoatModel::m_246613_);
        event.registerLayerDefinition(ModelLayers.RUBBERWOOD_CHEST_BOAT_LAYER, ChestBoatModel::m_247175_);
    }

    private void entityRendererSetup(EntityRenderersEvent.RegisterRenderers event) {
        PROXY.registerBoatModels(event);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(TFndBlocks::setup);
    }

    private void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(this::registerRenderLayers);
        event.enqueueWork(() -> Sheets.addWoodType((WoodType)WOOD_TYPE_RUBBERWOOD));
    }

    private void registerRenderLayers() {
        RenderType cutout = RenderType.m_110463_();
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("rubberwood_sapling")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("potted_rubberwood_sapling")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("rubberwood_door")), (RenderType)cutout);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)ThermalCore.BLOCKS.get("rubberwood_trapdoor")), (RenderType)cutout);
    }
}

