/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.teleporter.data;

import java.util.function.BiConsumer;
import java.util.function.Function;
import mcjty.lib.blockcommands.ISerializer;
import mcjty.rftoolsutility.modules.teleporter.data.TeleportDestination;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class TransmitterInfo {
    private final BlockPos coordinate;
    private final String name;
    private final TeleportDestination teleportDestination;

    public TransmitterInfo(FriendlyByteBuf buf) {
        this.coordinate = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.name = buf.m_130136_(Short.MAX_VALUE);
        this.teleportDestination = new TeleportDestination(buf);
    }

    public TransmitterInfo(BlockPos coordinate, String name, TeleportDestination destination) {
        this.coordinate = coordinate;
        this.name = name;
        this.teleportDestination = destination == null ? new TeleportDestination(null, (ResourceKey<Level>)Level.f_46428_) : destination;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.coordinate.m_123341_());
        buf.writeInt(this.coordinate.m_123342_());
        buf.writeInt(this.coordinate.m_123343_());
        buf.m_130070_(this.getName());
        this.teleportDestination.toBytes(buf);
    }

    public BlockPos getCoordinate() {
        return this.coordinate;
    }

    public String getName() {
        return this.name;
    }

    public TeleportDestination getTeleportDestination() {
        return this.teleportDestination;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransmitterInfo that = (TransmitterInfo)o;
        if (this.coordinate != null ? !this.coordinate.equals((Object)that.coordinate) : that.coordinate != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return this.teleportDestination.equals(that.teleportDestination);
    }

    public int hashCode() {
        int result = this.coordinate != null ? this.coordinate.hashCode() : 0;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + this.teleportDestination.hashCode();
        return result;
    }

    public static class Serializer
    implements ISerializer<TransmitterInfo> {
        public Function<FriendlyByteBuf, TransmitterInfo> getDeserializer() {
            return TransmitterInfo::new;
        }

        public BiConsumer<FriendlyByteBuf, TransmitterInfo> getSerializer() {
            return (buf, s) -> s.toBytes((FriendlyByteBuf)buf);
        }
    }
}

