/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.network;

import java.util.HashMap;
import java.util.Map;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.varia.LevelTools;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsbase.api.screens.data.IModuleDataFactory;
import mcjty.rftoolsutility.RFToolsUtility;
import mcjty.rftoolsutility.modules.screen.blocks.ScreenTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;

public record PacketReturnScreenData(GlobalPos pos, Map<Integer, IModuleData> screenData) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("rftoolsutility", "returnscreendata");

    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos.m_122646_());
        buf.m_130085_(this.pos.m_122640_().m_135782_());
        buf.writeInt(this.screenData.size());
        for (Map.Entry<Integer, IModuleData> me : this.screenData.entrySet()) {
            buf.writeInt(me.getKey().intValue());
            IModuleData c = me.getValue();
            buf.writeInt(RFToolsUtility.screenModuleRegistry.getShortId(c.getId()));
            c.writeToBuf(buf);
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    public GlobalPos getPos() {
        return this.pos;
    }

    public Map<Integer, IModuleData> getScreenData() {
        return this.screenData;
    }

    public static PacketReturnScreenData create(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        ResourceKey dim = LevelTools.getId((ResourceLocation)buf.m_130281_());
        int size = buf.readInt();
        HashMap<Integer, IModuleData> screenData = new HashMap<Integer, IModuleData>(size);
        for (int i = 0; i < size; ++i) {
            int key = buf.readInt();
            int shortId = buf.readInt();
            String id = RFToolsUtility.screenModuleRegistry.getNormalId(shortId);
            IModuleDataFactory<?> dataFactory = RFToolsUtility.screenModuleRegistry.getModuleDataFactory(id);
            IModuleData data = dataFactory.createData(buf);
            screenData.put(key, data);
        }
        return new PacketReturnScreenData(GlobalPos.m_122643_((ResourceKey)dim, (BlockPos)pos), screenData);
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ScreenTileEntity.screenData.put(this.getPos(), this.getScreenData()));
    }
}

