/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen.modulesclient;

import mcjty.rftoolsbase.api.screens.IClientScreenModule;
import mcjty.rftoolsbase.api.screens.IModuleRenderHelper;
import mcjty.rftoolsbase.api.screens.ITextRenderHelper;
import mcjty.rftoolsbase.api.screens.ModuleRenderInfo;
import mcjty.rftoolsbase.api.screens.TextAlign;
import mcjty.rftoolsbase.api.screens.data.IModuleData;
import mcjty.rftoolsbase.tools.ScreenTextHelper;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class TextClientScreenModule
implements IClientScreenModule<IModuleData> {
    private String line = "";
    private int color = 0xFFFFFF;
    private final ITextRenderHelper cache = new ScreenTextHelper();

    public IClientScreenModule.TransformMode getTransformMode() {
        return this.cache.isLarge() ? IClientScreenModule.TransformMode.TEXTLARGE : IClientScreenModule.TransformMode.TEXT;
    }

    public int getHeight() {
        return this.cache.isLarge() ? 20 : 10;
    }

    public void render(GuiGraphics graphics, MultiBufferSource buffer, IModuleRenderHelper renderHelper, Font fontRenderer, int currenty, IModuleData screenData, ModuleRenderInfo renderInfo) {
        this.cache.setup(this.line, 512, renderInfo);
        int y = this.cache.isLarge() ? currenty / 2 + 1 : currenty;
        this.cache.renderText(graphics, buffer, 0, y, this.color, renderInfo);
    }

    public void mouseClick(Level world, int x, int y, boolean clicked) {
    }

    public void setLine(String line) {
        this.line = line;
        this.cache.setDirty();
    }

    public void setColor(int color) {
        this.color = color;
        this.cache.setDirty();
    }

    public void setLarge(boolean large) {
        this.cache.large(large);
        this.cache.setDirty();
    }

    public void setupFromNBT(CompoundTag tagCompound, ResourceKey<Level> dim, BlockPos pos) {
        if (tagCompound != null) {
            this.line = tagCompound.m_128461_("text");
            this.color = tagCompound.m_128441_("color") ? tagCompound.m_128451_("color") : 0xFFFFFF;
            this.cache.large(tagCompound.m_128471_("large"));
            if (tagCompound.m_128441_("align")) {
                String alignment = tagCompound.m_128461_("align");
                this.cache.align(TextAlign.get((String)alignment));
            } else {
                this.cache.align(TextAlign.ALIGN_LEFT);
            }
        }
    }

    public boolean needsServerData() {
        return false;
    }
}

