/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.mixin;

import com.legacy.structure_gel.api.block.base.IStructureGel;
import com.legacy.structure_gel.api.block_entity.IRotatable;
import com.legacy.structure_gel.api.structure.base.IModifyState;
import com.legacy.structure_gel.api.structure.processor.RemoveGelStructureProcessor;
import com.legacy.structure_gel.core.capability.misc.StructureSettingsData;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.commands.PlaceCommand;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

public class TemplateMixins {

    @Mixin(value={StructureBlockEntity.class})
    public static class StructureBlockEntityMixin {
        @ModifyArg(at=@At(value="INVOKE", target="net/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate.placeInWorld(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructurePlaceSettings;Lnet/minecraft/util/RandomSource;I)Z"), method={"loadStructure(Lnet/minecraft/server/level/ServerLevel;ZLnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate;)Z"})
        private StructurePlaceSettings modifySettings_loadStructure(StructurePlaceSettings settings) {
            ((StructureSettingsData)settings).structure_gel$setNatural(false);
            return settings;
        }
    }

    @Mixin(value={PlaceCommand.class})
    public static class PlaceCommandMixin {
        @ModifyArg(at=@At(value="INVOKE", target="net/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate.placeInWorld(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructurePlaceSettings;Lnet/minecraft/util/RandomSource;I)Z"), method={"placeTemplate"})
        private static StructurePlaceSettings modifySettings_placeTemplate(StructurePlaceSettings settings) {
            ((StructureSettingsData)settings).structure_gel$setNatural(false);
            return settings;
        }
    }

    @Mixin(value={StructureTemplate.class})
    public static class StructureTemplateMixin {
        @Inject(at={@At(value="HEAD")}, remap=false, method={"processBlockInfos(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructurePlaceSettings;Ljava/util/List;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate;)Ljava/util/List;"})
        private static void addGelProcessor_processBlockInfos(ServerLevelAccessor pServerLevel, BlockPos pOffset, BlockPos p_74520_, StructurePlaceSettings settings, List<StructureTemplate.StructureBlockInfo> blockInfos, @Nullable StructureTemplate template, CallbackInfoReturnable<List<StructureTemplate.StructureBlockInfo>> callback) {
            StructureSettingsData settingsData = (StructureSettingsData)settings;
            if (settingsData.structure_gel$isNatural() && !settings.m_74411_().contains((Object)RemoveGelStructureProcessor.INSTANCE) && blockInfos.stream().anyMatch(info -> info.f_74676_().m_60734_() instanceof IStructureGel)) {
                settings.m_74411_().add(0, RemoveGelStructureProcessor.INSTANCE);
            }
        }

        @Inject(at={@At(value="TAIL")}, remap=false, method={"processBlockInfos(Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/core/BlockPos;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructurePlaceSettings;Ljava/util/List;Lnet/minecraft/world/level/levelgen/structure/templatesystem/StructureTemplate;)Ljava/util/List;"})
        private static void modifyStates_processBlockInfos(ServerLevelAccessor level, BlockPos pOffset, BlockPos p_74520_, StructurePlaceSettings settings, List<StructureTemplate.StructureBlockInfo> blockInfos, @Nullable StructureTemplate template, CallbackInfoReturnable<List<StructureTemplate.StructureBlockInfo>> callback) {
            IModifyState stateModifier;
            StructureSettingsData settingsData = (StructureSettingsData)settings;
            if (settingsData.structure_gel$isNatural() && (stateModifier = settingsData.structure_gel$getStateModifier()) != IModifyState.NOOP) {
                RandomSource rand = level.m_213780_();
                List processedBlocks = (List)callback.getReturnValue();
                ArrayList<Integer> toRemove = new ArrayList<Integer>();
                int size = processedBlocks.size();
                for (int i = 0; i < size; ++i) {
                    StructureTemplate.StructureBlockInfo info = (StructureTemplate.StructureBlockInfo)processedBlocks.get(i);
                    BlockState state = info.f_74676_();
                    BlockPos infoPos = info.f_74675_();
                    BlockState modifiedState = stateModifier.modifyState(level, rand, infoPos, state);
                    if (modifiedState == null) {
                        toRemove.add(i);
                        continue;
                    }
                    if (state == modifiedState) continue;
                    processedBlocks.set(i, new StructureTemplate.StructureBlockInfo(infoPos, modifiedState, info.f_74677_()));
                }
                int removeCount = toRemove.size();
                if (removeCount > 0) {
                    for (int i = removeCount - 1; i > -1; --i) {
                        processedBlocks.remove((Integer)toRemove.get(i));
                    }
                }
            }
        }

        @Inject(at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/entity/BlockEntity;load(Lnet/minecraft/nbt/CompoundTag;)V", shift=At.Shift.AFTER)}, method={"placeInWorld"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION)
        private void placeInWorld_loadBlockEntity(ServerLevelAccessor p_230329_, BlockPos p_230330_, BlockPos p_230331_, StructurePlaceSettings settings, RandomSource p_230333_, int p_230334_, CallbackInfoReturnable<Boolean> callback, List list, BoundingBox boundingbox, List list1, List list2, List list3, int i, int j, int k, int l, int i1, int j1, Iterator iterator, StructureTemplate.StructureBlockInfo info, BlockPos pos, FluidState fluidState, BlockState blockState, BlockEntity blockentity1) {
            if (blockentity1 instanceof IRotatable) {
                IRotatable r = (IRotatable)blockentity1;
                r.transform(settings.m_74401_(), settings.m_74404_());
            }
        }
    }

    @Mixin(value={StructurePlaceSettings.class})
    public static class StructurePlaceSettingsMixin
    implements StructureSettingsData {
        private boolean structure_gel$setNatural = true;
        private IModifyState structure_gel$stateModifier = IModifyState.NOOP;

        @Override
        public void structure_gel$setNatural(boolean natural) {
            this.structure_gel$setNatural = natural;
        }

        @Override
        public boolean structure_gel$isNatural() {
            return this.structure_gel$setNatural;
        }

        @Override
        public void structure_gel$setStateModifier(IModifyState modifier) {
            this.structure_gel$stateModifier = modifier;
        }

        @Override
        public IModifyState structure_gel$getStateModifier() {
            return this.structure_gel$stateModifier;
        }
    }
}

