/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool;

import net.minecraft.core.Vec3i;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;

public final class SmartBoundingBox {
    private final CornerType cornerA;
    private final CornerType cornerB;
    private int ax;
    private int ay;
    private int az;
    private int bx;
    private int by;
    private int bz;

    public SmartBoundingBox(int ax, int ay, int az, int bx, int by, int bz) {
        this.ax = ax;
        this.ay = ay;
        this.az = az;
        this.bx = bx;
        this.by = by;
        this.bz = bz;
        this.cornerA = CornerType.getFromPositions(ax, ay, az, bx, by, bz);
        this.cornerB = this.cornerA.opposite();
    }

    public static SmartBoundingBox fromCorners(Vec3i a, Vec3i b) {
        return new SmartBoundingBox(a.m_123341_(), a.m_123342_(), a.m_123343_(), b.m_123341_(), b.m_123342_(), b.m_123343_());
    }

    public static SmartBoundingBox from(SmartBoundingBox bounds) {
        return SmartBoundingBox.fromCorners(bounds.getPosA(), bounds.getPosB());
    }

    public static SmartBoundingBox zero() {
        return new SmartBoundingBox(0, 0, 0, 0, 0, 0);
    }

    public void set(BoundingBox newBounds) {
        this.setPosA(this.cornerA.getPosFromBounds(newBounds));
        this.setPosB(this.cornerB.getPosFromBounds(newBounds));
    }

    public Vec3i getPosA() {
        return this.getCorner(this.cornerA);
    }

    public void setPosA(Vec3i a) {
        this.setCorner(this.cornerA, a);
    }

    public Vec3i getPosB() {
        return this.getCorner(this.cornerB);
    }

    public void setPosB(Vec3i b) {
        this.setCorner(this.cornerB, b);
    }

    public Vec3i getMin() {
        return this.getCorner(CornerType.NNN);
    }

    public void setMin(Vec3i min) {
        this.setCorner(CornerType.NNN, min);
    }

    public Vec3i getMax() {
        return this.getCorner(CornerType.PPP);
    }

    public void setMax(Vec3i max) {
        this.setCorner(CornerType.PPP, max);
    }

    public int getXSpan() {
        return this.getCorner(CornerType.PPP).m_123341_() - this.getCorner(CornerType.NNN).m_123341_() + 1;
    }

    public int getYSpan() {
        return this.getCorner(CornerType.PPP).m_123342_() - this.getCorner(CornerType.NNN).m_123342_() + 1;
    }

    public int getZSpan() {
        return this.getCorner(CornerType.PPP).m_123343_() - this.getCorner(CornerType.NNN).m_123343_() + 1;
    }

    public Corner[] allCorners() {
        CornerType[] cornerTypes = CornerType.values();
        Corner[] corners = new Corner[8];
        for (int i = 0; i < 8; ++i) {
            corners[i] = new Corner(cornerTypes[i], cornerTypes[i].getPosFromBounds(this.ax, this.ay, this.az, this.bx, this.by, this.bz));
        }
        return corners;
    }

    public Corner[] selectionPointCorners() {
        return new Corner[]{new Corner(this.cornerA, this.cornerA.getPosFromBounds(this.ax, this.ay, this.az, this.bx, this.by, this.bz)), new Corner(this.cornerB, this.cornerB.getPosFromBounds(this.ax, this.ay, this.az, this.bx, this.by, this.bz))};
    }

    public Vec3i getCorner(CornerType corner) {
        return corner.getPosFromBounds(this.ax, this.ay, this.az, this.bx, this.by, this.bz);
    }

    public void setCorner(CornerType corner, Vec3i pos) {
        if (this.cornerA.xPositive == corner.xPositive) {
            this.ax = pos.m_123341_();
        } else if (this.cornerB.xPositive == corner.xPositive) {
            this.bx = pos.m_123341_();
        }
        if (this.cornerA.yPositive == corner.yPositive) {
            this.ay = pos.m_123342_();
        } else if (this.cornerB.yPositive == corner.yPositive) {
            this.by = pos.m_123342_();
        }
        if (this.cornerA.zPositive == corner.zPositive) {
            this.az = pos.m_123343_();
        } else if (this.cornerB.zPositive == corner.zPositive) {
            this.bz = pos.m_123343_();
        }
    }

    public void moveTo(Vec3i pos) {
        this.moveTo(CornerType.NNN, pos);
    }

    public void moveTo(CornerType corner, Vec3i pos) {
        Vec3i a = this.getCorner(corner);
        Vec3i b = this.getCorner(corner.opposite());
        int dx = b.m_123341_() - a.m_123341_();
        int dy = b.m_123342_() - a.m_123342_();
        int dz = b.m_123343_() - a.m_123343_();
        this.setCorner(corner, pos);
        this.setCorner(corner.opposite(), pos.m_7918_(dx, dy, dz));
    }

    public BoundingBox bounds() {
        return BoundingBox.m_162375_((Vec3i)this.getPosA(), (Vec3i)this.getPosB());
    }

    public AABB aabb() {
        return AABB.m_82321_((BoundingBox)this.bounds());
    }

    public boolean equals(Object obj) {
        boolean bl;
        if (obj instanceof SmartBoundingBox) {
            SmartBoundingBox bb = (SmartBoundingBox)obj;
            bl = this.ax == bb.ax && this.ay == bb.ay && this.az == bb.az && this.bx == bb.bx && this.by == bb.by && this.bz == bb.bz;
        } else {
            bl = false;
        }
        return bl;
    }

    public static enum CornerType {
        NNN(false, false, false),
        NNP(false, false, true),
        NPN(false, true, false),
        NPP(false, true, true),
        PNN(true, false, false),
        PNP(true, false, true),
        PPN(true, true, false),
        PPP(true, true, true);

        final boolean xPositive;
        final boolean yPositive;
        final boolean zPositive;

        private CornerType(boolean xPositive, boolean yPositive, boolean zPositive) {
            this.xPositive = xPositive;
            this.yPositive = yPositive;
            this.zPositive = zPositive;
        }

        public static CornerType getFromPositions(int x, int y, int z, int otherX, int otherY, int otherZ) {
            int lowX = x < otherX ? 0 : 4;
            int lowY = y < otherY ? 0 : 2;
            int lowZ = z < otherZ ? 0 : 1;
            return CornerType.values()[lowX | lowY | lowZ];
        }

        public CornerType opposite() {
            return CornerType.values()[7 - this.ordinal()];
        }

        public Vec3i getPosFromBounds(BoundingBox bb) {
            return this.getPosFromBounds(bb.m_162395_(), bb.m_162396_(), bb.m_162398_(), bb.m_162399_(), bb.m_162400_(), bb.m_162401_());
        }

        public Vec3i getPosFromBounds(int ax, int ay, int az, int bx, int by, int bz) {
            return new Vec3i(this.getCoord(this.xPositive, ax, bx), this.getCoord(this.yPositive, ay, by), this.getCoord(this.zPositive, az, bz));
        }

        private int getCoord(boolean isPositive, int a, int b) {
            return isPositive ? Math.max(a, b) : Math.min(a, b);
        }
    }

    public static class Corner {
        public final CornerType type;
        public int x;
        public int y;
        public int z;

        public Corner(CornerType type, int x, int y, int z) {
            this.type = type;
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Corner(CornerType type, Vec3i pos) {
            this(type, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        }

        public Vec3i getPos() {
            return new Vec3i(this.x, this.y, this.z);
        }

        public Vec3i getPoint() {
            return new Vec3i(this.type.xPositive ? this.x + 1 : this.x, this.type.yPositive ? this.y + 1 : this.y, this.type.zPositive ? this.z + 1 : this.z);
        }
    }
}

