/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.workbench;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraftforge.common.crafting.AbstractIngredient;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;

public class EnchantmentIngredient
extends AbstractIngredient {
    public static final String NAME = "enchantment_ingredient";
    private final ItemStack stack;
    private final List<EnchantmentInstance> enchantments;
    private final CompoundTag withoutEnchantment;
    private final boolean checkDamage;
    private final boolean checkOtherTags;

    public EnchantmentIngredient(ItemStack stack, List<EnchantmentInstance> enchantments, boolean checkDamage, boolean checkOtherTags) {
        super(Stream.of(new Ingredient.ItemValue(EnchantmentIngredient.addEnchantments(stack, enchantments))));
        this.stack = stack;
        this.enchantments = enchantments;
        this.withoutEnchantment = EnchantmentIngredient.getTagWithoutEnchantment(stack, checkDamage);
        this.checkDamage = checkDamage;
        this.checkOtherTags = checkOtherTags;
    }

    public boolean isSimple() {
        return false;
    }

    public JsonObject toJson() {
        JsonObject object = new JsonObject();
        Serializer.INSTANCE.write(object, this);
        return object;
    }

    public boolean test(@Nullable ItemStack stack) {
        int actualDamage;
        int expectedDamage;
        if (stack == null) {
            return false;
        }
        if (this.stack.m_41720_() != stack.m_41720_()) {
            return false;
        }
        Map enchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        if (!this.enchantments.stream().allMatch(d -> enchantments.getOrDefault(d.f_44947_, 0) >= d.f_44948_)) {
            return false;
        }
        if (this.checkDamage && (expectedDamage = this.stack.m_41773_()) != (actualDamage = stack.m_41773_())) {
            return false;
        }
        if (this.checkOtherTags) {
            CompoundTag nbt = EnchantmentIngredient.getTagWithoutEnchantment(stack, this.checkDamage);
            return Objects.equals(this.withoutEnchantment, nbt);
        }
        return true;
    }

    private static ItemStack addEnchantments(ItemStack stack, List<EnchantmentInstance> enchantments) {
        ItemStack toEnchantment = stack.m_41777_();
        enchantments.forEach(d -> toEnchantment.m_41663_(d.f_44947_, d.f_44948_));
        return toEnchantment;
    }

    @Nullable
    private static CompoundTag getTagWithoutEnchantment(ItemStack stack, boolean checkDamage) {
        return Optional.ofNullable(stack.getShareTag()).map(CompoundTag::m_6426_).map(c -> {
            c.m_128473_("Enchantments");
            c.m_128473_("StoredEnchantments");
            if (!checkDamage) {
                c.m_128473_("Damage");
            }
            return c;
        }).filter(Predicate.not(CompoundTag::m_128456_)).orElse(null);
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<EnchantmentIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public EnchantmentIngredient parse(FriendlyByteBuf buffer) {
            ItemStack stack = buffer.m_130267_();
            int size = buffer.m_130242_();
            List<EnchantmentInstance> data = IntStream.range(0, size).mapToObj(operand -> {
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(buffer.m_130281_());
                int level = buffer.readInt();
                return new EnchantmentInstance(Objects.requireNonNull(enchantment), level);
            }).collect(Collectors.toList());
            boolean checkDamage = buffer.readBoolean();
            boolean checkOtherTags = buffer.readBoolean();
            return new EnchantmentIngredient(stack, data, checkDamage, checkOtherTags);
        }

        public EnchantmentIngredient parse(JsonObject json) {
            List<Object> data;
            ItemStack stack = CraftingHelper.getItemStack((JsonObject)json, (boolean)true);
            boolean checkDamage = GsonHelper.m_13855_((JsonObject)json, (String)"checkDamage", (boolean)false);
            boolean checkOtherTags = GsonHelper.m_13855_((JsonObject)json, (String)"checkOtherTags", (boolean)false);
            if (json.has("enchantments")) {
                JsonArray enchantmentArray = json.getAsJsonArray("enchantments");
                data = StreamSupport.stream(enchantmentArray.spliterator(), false).map(JsonElement::getAsJsonObject).map(o -> {
                    Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)o, (String)"id")));
                    int level = GsonHelper.m_13824_((JsonObject)o, (String)"level", (int)1);
                    return new EnchantmentInstance(Objects.requireNonNull(enchantment), level);
                }).collect(Collectors.toList());
            } else {
                data = Collections.emptyList();
            }
            return new EnchantmentIngredient(stack, data, checkDamage, checkOtherTags);
        }

        public void write(FriendlyByteBuf buffer, EnchantmentIngredient ingredient) {
            buffer.writeItemStack(ingredient.stack, false);
            buffer.m_130130_(ingredient.enchantments.size());
            for (EnchantmentInstance data : ingredient.enchantments) {
                buffer.m_130085_(Objects.requireNonNull(ForgeRegistries.ENCHANTMENTS.getKey((Object)data.f_44947_)));
                buffer.writeInt(data.f_44948_);
            }
            buffer.writeBoolean(ingredient.checkDamage);
            buffer.writeBoolean(ingredient.checkOtherTags);
        }

        public void write(JsonObject json, EnchantmentIngredient ingredient) {
            JsonArray enchantmentArray;
            json.addProperty("type", CraftingHelper.getID((IIngredientSerializer)INSTANCE).toString());
            json.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)ingredient.stack.m_41720_())).toString());
            json.addProperty("count", (Number)ingredient.stack.m_41613_());
            json.addProperty("checkDamage", Boolean.valueOf(ingredient.checkDamage));
            json.addProperty("checkOtherTags", Boolean.valueOf(ingredient.checkOtherTags));
            if (ingredient.withoutEnchantment != null) {
                JsonElement element = (JsonElement)Dynamic.convert((DynamicOps)NbtOps.f_128958_, (DynamicOps)JsonOps.INSTANCE, (Object)ingredient.withoutEnchantment);
                json.add("nbt", element);
            }
            if (!(enchantmentArray = ingredient.enchantments.stream().reduce(new JsonArray(), (jsonElements, enchantmentData) -> {
                JsonObject object = new JsonObject();
                object.addProperty("id", Objects.requireNonNull(ForgeRegistries.ENCHANTMENTS.getKey((Object)enchantmentData.f_44947_)).toString());
                object.addProperty("level", (Number)enchantmentData.f_44948_);
                jsonElements.add((JsonElement)object);
                return jsonElements;
            }, (jsonElements, jsonElements2) -> {
                jsonElements.addAll(jsonElements2);
                return jsonElements;
            })).isEmpty()) {
                json.add("enchantments", (JsonElement)enchantmentArray);
            }
        }
    }
}

