/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.placer;

import com.yogpc.qp.machines.misc.IndexedButton;
import com.yogpc.qp.machines.placer.PlacerContainer;
import com.yogpc.qp.machines.placer.PlacerScreen;
import com.yogpc.qp.machines.placer.PlacerTile;
import com.yogpc.qp.machines.placer.RemotePlacerMessage;
import com.yogpc.qp.machines.placer.RemotePlacerTile;
import com.yogpc.qp.packet.PacketHandler;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class RemotePlacerScreen
extends PlacerScreen
implements Button.OnPress {
    private static final ResourceLocation LOCATION = new ResourceLocation("quarryplus", "textures/gui/remote_replacer.png");

    public RemotePlacerScreen(PlacerContainer c, Inventory inventory, Component component) {
        super(c, inventory, component);
    }

    @Override
    protected ResourceLocation textureLocation() {
        return LOCATION;
    }

    protected void m_7856_() {
        super.m_7856_();
        AtomicInteger counter = new AtomicInteger(0);
        for (int i = 0; i < 3; ++i) {
            int yPos = this.getGuiTop() + 21 + i * 18;
            this.m_142416_((GuiEventListener)new IndexedButton(counter.getAndIncrement(), this.getGuiLeft() + 97, yPos, 18, 9, (Component)Component.m_237113_((String)"-"), this));
            this.m_142416_((GuiEventListener)new IndexedButton(counter.getAndIncrement(), this.getGuiLeft() + 151, yPos, 18, 9, (Component)Component.m_237113_((String)"+"), this));
        }
    }

    @Override
    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280003_(graphics, mouseX, mouseY);
        BlockPos targetPos = ((PlacerContainer)this.m_6262_()).tile.getTargetPos();
        int color = targetPos.equals((Object)((PlacerContainer)this.m_6262_()).tile.m_58899_()) ? 0xFF4040 : 0x404040;
        int x = 116;
        graphics.m_280056_(this.f_96547_, "X: " + targetPos.m_123341_(), x, 22, color, false);
        graphics.m_280056_(this.f_96547_, "Y: " + targetPos.m_123342_(), x, 40, color, false);
        graphics.m_280056_(this.f_96547_, "Z: " + targetPos.m_123343_(), x, 58, color, false);
    }

    @Override
    protected void renderModeLabel(GuiGraphics graphics) {
        String pA;
        PlacerTile.RedstoneMode mode = ((PlacerContainer)this.m_6262_()).tile.redstoneMode;
        String string = pA = mode.isAlways() ? "Always" : "Pulse";
        String rs = mode.isRsOn() ? "RS On" : (mode.isRsOff() ? "RS Off" : "");
        String only = mode.canBreak() && !mode.canPlace() ? "Break" : (mode.canPlace() && !mode.canBreak() ? "Place" : "");
        graphics.m_280056_(this.f_96547_, pA, 90, 6, 0x404040, false);
        graphics.m_280056_(this.f_96547_, only, 130, 6, 0x404040, false);
        graphics.m_280056_(this.f_96547_, rs, 100, this.f_97731_, 0x404040, false);
    }

    public void m_93750_(Button pButton) {
        if (pButton instanceof IndexedButton) {
            IndexedButton indexedButton = (IndexedButton)pButton;
            PlacerTile placerTile = ((PlacerContainer)this.m_6262_()).tile;
            if (placerTile instanceof RemotePlacerTile) {
                BlockPos newPos;
                RemotePlacerTile remotePlacerTile = (RemotePlacerTile)placerTile;
                int amount = (switch (indexedButton.getIndex() % 2) {
                    case 0 -> -1;
                    case 1 -> 1;
                    default -> throw new AssertionError((Object)"X % 2 must in 0-1.");
                }) * (Screen.m_96638_() ? 16 : (Screen.m_96637_() ? 4 : 1));
                Direction.Axis axis = switch (indexedButton.getIndex() / 2) {
                    case 0 -> Direction.Axis.X;
                    case 1 -> Direction.Axis.Y;
                    case 2 -> Direction.Axis.Z;
                    default -> throw new IllegalArgumentException("Bad index " + indexedButton.getIndex());
                };
                remotePlacerTile.targetPos = newPos = remotePlacerTile.getTargetPos().m_5487_(axis, amount);
                PacketHandler.sendToServer(new RemotePlacerMessage(remotePlacerTile, newPos));
            }
        }
    }
}

