/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.module;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.ItemConverter;
import com.yogpc.qp.machines.ItemKey;
import com.yogpc.qp.machines.module.QuarryModule;
import com.yogpc.qp.utils.MapMulti;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class FilterModule
implements QuarryModule {
    @Nullable
    private final ListTag listTag;

    public FilterModule(@NotNull List<ItemKey> itemKeys) {
        this(FilterModule.getFromItemKeys(itemKeys.stream()));
    }

    public FilterModule(@Nullable ListTag tag) {
        this.listTag = tag;
    }

    public static List<ItemKey> getFromTag(@Nullable ListTag tag) {
        if (tag == null || tag.isEmpty()) {
            return List.of();
        }
        return tag.stream().mapMulti(MapMulti.cast(CompoundTag.class)).map(ItemKey::fromNbt).distinct().toList();
    }

    public static ListTag getFromItems(List<ItemStack> stacks) {
        return FilterModule.getFromItemKeys(stacks.stream().map(ItemKey::new));
    }

    static ListTag getFromItemKeys(Stream<ItemKey> keyStream) {
        return keyStream.map(ItemKey::createNbt).collect(Collectors.toCollection(ListTag::new));
    }

    @Override
    public ResourceLocation moduleId() {
        return Holder.ITEM_FILTER_MODULE.getRegistryName();
    }

    public ItemConverter createConverter() {
        return ItemConverter.voidConverter(this.getItemKeys());
    }

    @VisibleForTesting
    List<ItemKey> getItemKeys() {
        return FilterModule.getFromTag(this.listTag);
    }

    public String toString() {
        int size = this.listTag == null ? 0 : this.listTag.size();
        return "FilterModule{size=" + size + "}";
    }
}

