/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.bookmover;

import com.yogpc.qp.Holder;
import com.yogpc.qp.machines.bookmover.BookMoverEntity;
import com.yogpc.qp.machines.misc.SlotContainer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BookMoverMenu
extends AbstractContainerMenu {
    private final BookMoverEntity mover;
    private final DataSlot progress = this.m_38895_(DataSlot.m_39401_());
    private final DataSlot isWorking = this.m_38895_(DataSlot.m_39401_());

    public BookMoverMenu(int id, Player player, BlockPos pos) {
        super(Holder.BOOK_MOVER_MENU_TYPE, id);
        this.mover = (BookMoverEntity)player.m_9236_().m_7702_(pos);
        if (this.mover != null) {
            this.m_38897_(new SlotContainer(this.mover, 0, 13, 35));
            this.m_38897_(new SlotContainer(this.mover, 1, 55, 35));
            this.m_38897_(new SlotContainer(this.mover, 2, 116, 35));
            if (!player.m_9236_().f_46443_) {
                this.setTrackValues();
            }
        }
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_(new Slot((Container)player.m_150109_(), j + i * 9 + 9, 8 + j * 18, 84 + i * 18));
            }
        }
        for (int k = 0; k < 9; ++k) {
            this.m_38897_(new Slot((Container)player.m_150109_(), k, 8 + k * 18, 142));
        }
    }

    private void setTrackValues() {
        this.progress.m_6422_(1000 * this.mover.getEnergyStored() / this.mover.getMaxEnergyStored());
        this.isWorking.m_6422_(this.mover.isWorking() ? 1 : 0);
    }

    public boolean m_6875_(Player playerIn) {
        return this.mover.m_6542_(playerIn);
    }

    public ItemStack m_7648_(Player player, int index) {
        int allSlots = 3;
        Slot slot = this.m_38853_(index);
        if (slot.m_6657_()) {
            ItemStack remain = slot.m_7993_();
            ItemStack slotContent = remain.m_41777_();
            if (index < allSlots ? !this.m_38903_(remain, allSlots, 36 + allSlots, true) : !this.m_38903_(remain, 0, allSlots, false)) {
                return ItemStack.f_41583_;
            }
            if (remain.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (remain.m_41613_() == slotContent.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(player, remain);
            return slotContent;
        }
        return ItemStack.f_41583_;
    }

    public void m_38946_() {
        this.setTrackValues();
        super.m_38946_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getProgress() {
        return this.progress.m_6501_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean moverIsWorking() {
        return this.isWorking.m_6501_() == 1;
    }
}

