/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.machines.advquarry;

import com.yogpc.qp.machines.Area;
import com.yogpc.qp.machines.advquarry.AdvActionMessage;
import com.yogpc.qp.machines.advquarry.AdvQuarryAction;
import com.yogpc.qp.machines.advquarry.AdvQuarryMenu;
import com.yogpc.qp.machines.advquarry.TileAdvQuarry;
import com.yogpc.qp.machines.advquarry.WorkConfig;
import com.yogpc.qp.machines.misc.IndexedButton;
import com.yogpc.qp.machines.misc.SmallCheckBox;
import com.yogpc.qp.packet.PacketHandler;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.ChunkPos;

public class AdvQuarryScreen
extends AbstractContainerScreen<AdvQuarryMenu>
implements Button.OnPress {
    private static final ResourceLocation LOCATION = new ResourceLocation("quarryplus", "textures/gui/adv_quarry.png");
    private SmallCheckBox areaFrameCheckBox;
    private SmallCheckBox chunkByChunkCheckBox;
    private SmallCheckBox startCheckBox;

    public AdvQuarryScreen(AdvQuarryMenu c, Inventory inventory, Component component) {
        super((AbstractContainerMenu)c, inventory, component);
        this.f_97726_ = c.imageWidth;
        this.f_97727_ = c.imageHeight;
        this.f_97731_ = this.f_97727_ - 96 + 2;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.m_280273_(graphics);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        this.m_280072_(graphics, mouseX, mouseY);
    }

    protected void m_7286_(GuiGraphics graphics, float delta, int mouseX, int mouseY) {
        int pX = this.getGuiLeft();
        int pY = this.getGuiTop();
        graphics.m_280218_(LOCATION, pX, pY, 0, 0, this.f_97726_, this.f_97727_);
    }

    protected void m_280003_(GuiGraphics graphics, int mouseX, int mouseY) {
        super.m_280003_(graphics, mouseX, mouseY);
        Area range = ((AdvQuarryMenu)this.m_6262_()).quarry.getArea();
        if (range != null) {
            ChunkPos chunkPos = new ChunkPos(((AdvQuarryMenu)this.m_6262_()).quarry.m_58899_());
            double north = chunkPos.m_45605_() - range.minZ() - 1;
            double south = range.maxZ() - chunkPos.m_45609_() - 1;
            double east = range.maxX() - chunkPos.m_45608_() - 1;
            double west = chunkPos.m_45604_() - range.minX() - 1;
            graphics.m_280056_(this.f_96547_, String.valueOf(north / 16.0), 77, 18, 0x404040, false);
            graphics.m_280056_(this.f_96547_, String.valueOf(south / 16.0), 77, 62, 0x404040, false);
            graphics.m_280056_(this.f_96547_, String.valueOf(west / 16.0), 24, 40, 0x404040, false);
            graphics.m_280056_(this.f_96547_, String.valueOf(east / 16.0), 131, 40, 0x404040, false);
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        MutableComponent plus = Component.m_237113_((String)"+");
        MutableComponent minus = Component.m_237113_((String)"-");
        this.m_142416_((GuiEventListener)new IndexedButton(0, this.getGuiLeft() + 99, this.getGuiTop() + 17, 12, 8, (Component)plus, this));
        this.m_142416_((GuiEventListener)new IndexedButton(1, this.getGuiLeft() + 64, this.getGuiTop() + 17, 12, 8, (Component)minus, this));
        this.m_142416_((GuiEventListener)new IndexedButton(2, this.getGuiLeft() + 99, this.getGuiTop() + 61, 12, 8, (Component)plus, this));
        this.m_142416_((GuiEventListener)new IndexedButton(3, this.getGuiLeft() + 64, this.getGuiTop() + 61, 12, 8, (Component)minus, this));
        this.m_142416_((GuiEventListener)new IndexedButton(4, this.getGuiLeft() + 46, this.getGuiTop() + 39, 12, 8, (Component)plus, this));
        this.m_142416_((GuiEventListener)new IndexedButton(5, this.getGuiLeft() + 11, this.getGuiTop() + 39, 12, 8, (Component)minus, this));
        this.m_142416_((GuiEventListener)new IndexedButton(6, this.getGuiLeft() + 153, this.getGuiTop() + 39, 12, 8, (Component)plus, this));
        this.m_142416_((GuiEventListener)new IndexedButton(7, this.getGuiLeft() + 118, this.getGuiTop() + 39, 12, 8, (Component)minus, this));
        this.m_142416_((GuiEventListener)new IndexedButton(8, this.getGuiLeft() + 118, this.getGuiTop() + 58, 50, 12, (Component)Component.m_237113_((String)"Start"), this));
        this.m_142416_((GuiEventListener)new IndexedButton(9, this.getGuiLeft() + 8, this.getGuiTop() + 58, 50, 12, (Component)Component.m_237113_((String)"Modules"), this));
        this.areaFrameCheckBox = new SmallCheckBox(this.getGuiLeft() + 8, this.getGuiTop() + 72, 60, 10, 10, 10, (Component)Component.m_237113_((String)"Area Frame"), ((AdvQuarryMenu)this.m_6262_()).quarry.workConfig.placeAreaFrame(), this);
        this.m_142416_((GuiEventListener)this.areaFrameCheckBox);
        this.chunkByChunkCheckBox = new SmallCheckBox(this.getGuiLeft() + 8, this.getGuiTop() + 83, 60, 10, 10, 10, (Component)Component.m_237113_((String)"Chunk by Chunk"), ((AdvQuarryMenu)this.m_6262_()).quarry.workConfig.chunkByChunk(), this);
        this.m_142416_((GuiEventListener)this.chunkByChunkCheckBox);
        this.startCheckBox = new SmallCheckBox(this.getGuiLeft() + 8, this.getGuiTop() + 94, 60, 10, 10, 10, (Component)Component.m_237113_((String)"Ready to Start"), ((AdvQuarryMenu)this.m_6262_()).quarry.workConfig.startImmediately(), this);
        this.m_142416_((GuiEventListener)this.startCheckBox);
    }

    public void m_93750_(Button b) {
        TileAdvQuarry tile = ((AdvQuarryMenu)this.m_6262_()).quarry;
        if (b instanceof IndexedButton) {
            IndexedButton button = (IndexedButton)b;
            if (button.id() == 8) {
                if (tile.getAction() == AdvQuarryAction.Waiting.WAITING) {
                    tile.workConfig = tile.workConfig.startSoonConfig();
                    this.startCheckBox.setSelected(tile.workConfig.startImmediately());
                    PacketHandler.sendToServer(new AdvActionMessage(tile, AdvActionMessage.Actions.QUICK_START));
                }
            } else if (button.id() == 9) {
                PacketHandler.sendToServer(new AdvActionMessage(tile, AdvActionMessage.Actions.MODULE_INV));
            } else if (tile.getAction() == AdvQuarryAction.Waiting.WAITING) {
                Direction direction = Direction.m_122376_((int)(button.id() / 2 + 2));
                int increase = button.id() % 2 == 0 ? 1 : -1;
                boolean shift = Screen.m_96638_();
                boolean ctrl = Screen.m_96637_();
                int t = shift && ctrl ? 1024 * increase : (shift ? 256 * increase : (ctrl ? 64 * increase : 16 * increase));
                Area range = tile.getArea();
                if (range != null) {
                    Area newRange = switch (direction.m_122434_()) {
                        case Direction.Axis.X -> {
                            int e;
                            switch (direction.m_122421_()) {
                                case POSITIVE: {
                                    e = range.maxX();
                                    if (range.minX() < e + t) {
                                        yield new Area(range.minX(), range.minY(), range.minZ(), e + t, range.maxY(), range.maxZ(), range.direction());
                                    }
                                    yield range;
                                }
                                case NEGATIVE: {
                                    e = range.minX();
                                    if (range.maxX() > e - t) {
                                        yield new Area(e - t, range.minY(), range.minZ(), range.maxX(), range.maxY(), range.maxZ(), range.direction());
                                    }
                                    yield range;
                                }
                            }
                            yield range;
                        }
                        case Direction.Axis.Z -> {
                            int e;
                            switch (direction.m_122421_()) {
                                case POSITIVE: {
                                    e = range.maxZ();
                                    if (range.minZ() < e + t) {
                                        yield new Area(range.minX(), range.minY(), range.minZ(), range.maxX(), range.maxY(), e + t, range.direction());
                                    }
                                    yield range;
                                }
                                case NEGATIVE: {
                                    e = range.minZ();
                                    if (range.maxZ() > e - t) {
                                        yield new Area(range.minX(), range.minY(), e - t, range.maxX(), range.maxY(), range.maxZ(), range.direction());
                                    }
                                    yield range;
                                }
                            }
                            yield range;
                        }
                        default -> tile.getArea();
                    };
                    PacketHandler.sendToServer(new AdvActionMessage(tile, AdvActionMessage.Actions.CHANGE_RANGE, newRange));
                }
            }
        }
        if (b instanceof SmallCheckBox) {
            WorkConfig workConfig;
            boolean placeAreaFrame = this.areaFrameCheckBox.isSelected();
            boolean chunkByChunk = this.chunkByChunkCheckBox.isSelected();
            boolean startImmediately = this.startCheckBox.isSelected();
            tile.workConfig = workConfig = new WorkConfig(startImmediately, placeAreaFrame, chunkByChunk);
            PacketHandler.sendToServer(new AdvActionMessage(tile, AdvActionMessage.Actions.SYNC, workConfig));
        }
    }
}

