/*
 * Decompiled with CFR 0.152.
 */
package com.yogpc.qp.integration.ftbchunks;

import com.yogpc.qp.QuarryPlus;
import com.yogpc.qp.machines.Area;
import dev.ftb.mods.ftbchunks.api.FTBChunksAPI;
import dev.ftb.mods.ftblibrary.math.ChunkDimPos;
import java.util.Locale;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.ModList;

public final class FTBChunksProtectionCheck {
    public static boolean isAreaProtected(Area area, ResourceKey<Level> dimension) {
        if (((Boolean)QuarryPlus.config.common.allowWorkInClaimedChunkByFBTChunks.get()).booleanValue()) {
            return false;
        }
        if (ModList.get().isLoaded("FtbChunks".toLowerCase(Locale.ROOT))) {
            return Accessor.doesAreaHasProtectedChunk(area, dimension);
        }
        return false;
    }

    static boolean doesAreaHasProtectedChunk(Area area, Predicate<ChunkPos> predicate) {
        return FTBChunksProtectionCheck.getChunkPosStream(area).anyMatch(predicate);
    }

    static Stream<ChunkPos> getChunkPosStream(Area area) {
        return IntStream.rangeClosed(Math.floorDiv(area.minX(), 16), Math.floorDiv(area.maxX(), 16)).boxed().flatMap(x -> IntStream.rangeClosed(Math.floorDiv(area.minZ(), 16), Math.floorDiv(area.maxZ(), 16)).boxed().map(z -> new ChunkPos(x.intValue(), z.intValue())));
    }

    private static final class Accessor {
        private Accessor() {
        }

        private static boolean isProtected(ResourceKey<Level> dimension, ChunkPos chunkPos) {
            return FTBChunksAPI.api().getManager().getChunk(new ChunkDimPos(dimension, chunkPos)) != null;
        }

        private static boolean doesAreaHasProtectedChunk(Area area, ResourceKey<Level> dimension) {
            return FTBChunksProtectionCheck.doesAreaHasProtectedChunk(area, (ChunkPos c) -> Accessor.isProtected(dimension, c));
        }
    }
}

