/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix;

import com.google.common.collect.ImmutableList;
import de.melanx.utilitix.util.ArmorStandRotation;
import java.util.List;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import org.moddingx.libx.config.Config;
import org.moddingx.libx.config.Group;
import org.moddingx.libx.config.validate.FloatRange;
import org.moddingx.libx.config.validate.IntRange;
import org.moddingx.libx.util.data.ResourceList;

public class UtilitiXConfig {
    @Config(value={"A list of armor stand rotations for armor stands with arms.", "You can cycle through these with a piece of flint."})
    public static List<ArmorStandRotation> armorStandPoses = ImmutableList.of((Object)ArmorStandRotation.defaultRotation(), (Object)ArmorStandRotation.create(3.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -10.0f, 0.0f, -10.0f, -15.0f, 0.0f, 10.0f, 25.0f, 0.0f, -1.0f, -25.0f, 0.0f, 1.0f), (Object)ArmorStandRotation.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -20.0f, 0.0f, -10.0f, -85.0f, 0.0f, 0.0f, -1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f), (Object)ArmorStandRotation.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -50.0f, 0.0f, 60.0f, -60.0f, -40.0f, 0.0f, -1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f), (Object)ArmorStandRotation.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -10.0f, 0.0f, -110.0f, -15.0f, 0.0f, 110.0f, -1.0f, 0.0f, -15.0f, 1.0f, 0.0f, 15.0f), (Object)ArmorStandRotation.create(70.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -10.0f, 0.0f, 5.0f, -15.0f, 0.0f, -5.0f, 3.0f, 0.0f, -1.0f, 3.0f, 0.0f, 1.0f), (Object)ArmorStandRotation.create(0.0f, -35.0f, -5.0f, 0.0f, 0.0f, 0.0f, -10.0f, 0.0f, -10.0f, -15.0f, 0.0f, 10.0f, -1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f), (Object)ArmorStandRotation.create(0.0f, 35.0f, 5.0f, 0.0f, 0.0f, 0.0f, -10.0f, 0.0f, -10.0f, -15.0f, 0.0f, 10.0f, -1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f), (Object)ArmorStandRotation.create(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, -10.0f, 0.0f, -10.0f, -40.0f, 0.0f, 55.0f, -1.0f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f));
    @Config(value={"Items in world which have mending collect xp orbs to get repaired"})
    public static boolean betterMending = true;
    @Config(value={"Illusioners will appear in raids"})
    public static boolean illusionerInRaid = true;
    @Config(value={"List of items which are allowed to be planted when despawn on correct soil"})
    public static ResourceList plantsOnDespawn = ResourceList.DENY_LIST;
    @Config(value={"Prevents waterlogging when holding the sneak key"})
    public static boolean crouchNoWaterlog = true;
    @Config(value={"The time in ticks which will be added to the despawn delay of a wandering trader on each trade", "This way, the wandering trader remains in the world longer."})
    @IntRange(min=0)
    public static int wanderingTraderExtraTime = 400;
    @Config(value={"Entity denylist for mob yoinker"})
    public static ResourceList mobYoinkerEntities = ResourceList.DENY_LIST;
    @Config(value={"Size scale for exporting maps", "1 = 128x128px", "2 = 256x256px", "3 = 384x384px", "And so on, you got the pattern I hope"})
    @IntRange(min=1)
    public static int mapScale = 3;
    @Config(value={"Both doors open at the same time if connected"})
    public static boolean doubleDoor = true;

    @Group(value={"Config options for experience crystal"})
    public static class ExperienceCrystal {
        @Config(value={"Should the experience crystal pull xp orbs automatically?"})
        public static boolean pullOrbs = true;
        @Config(value={"Maximum experience which can be stored"})
        @IntRange(min=0)
        public static int maxXp = Integer.MAX_VALUE;
        @Config(value={"A ResourceLocation for a fluid xp fluid. If it exists in the tag #forge:experience or #forge:xpjuice, the crystal will always store this type of fluid xp"})
        public static Optional<ResourceLocation> fluidXp = Optional.empty();
    }

    @Group(value={"Config options for rails and minecarts"})
    public static class Track {
        @Config(value={"The maximum hardness of blocks, the stonecutter cart can mine."})
        @FloatRange(min=0.0f)
        public static float stonecutterMaxHardness = 5.0f;
    }

    @Group
    public static class Backpack {
        @Config(value={"The initial size of a backpack"})
        @IntRange(min=1, max=154)
        public static int slotSize = 9;
        @Config(value={"The maximum size of a backpack when merging with other backpacks", "Beyond this number, backpacks cannot be merged"})
        @IntRange(min=1, max=154)
        public static int maxSize = 54;
    }

    @Group(value={"Config values for the two bells, mob bell and hand bell"})
    public static class HandBells {
        @Config(value={"Entity denylist for mob bell"})
        public static ResourceList mobBellEntities = ResourceList.DENY_LIST;
        @Config(value={"The time in ticks how long you have to ring the hand bell to let the mobs glow"})
        public static int ringTime = 40;
        @Config(value={"The time in ticks how long a mob should glow"})
        public static int glowTime = 60;
        @Config(value={"The radius in which entities will glow"})
        public static int glowRadius = 36;
        @Config(value={"The radius in which entities get notified that you rung"})
        public static int notifyRadius = 24;
    }
}

