/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core.part;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import org.cyclops.commoncapabilities.api.ingredient.IIngredientMatcher;
import org.cyclops.commoncapabilities.api.ingredient.IPrototypedIngredient;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.commoncapabilities.api.ingredient.IngredientInstanceWrapper;
import org.cyclops.commoncapabilities.api.ingredient.storage.IIngredientComponentStorage;
import org.cyclops.integratedcrafting.GeneralConfig;
import org.cyclops.integratedcrafting.api.crafting.CraftingJob;
import org.cyclops.integratedcrafting.api.crafting.CraftingJobStatus;
import org.cyclops.integratedcrafting.api.crafting.ICraftingInterface;
import org.cyclops.integratedcrafting.api.crafting.ICraftingResultsSink;
import org.cyclops.integratedcrafting.api.network.ICraftingNetwork;
import org.cyclops.integratedcrafting.capability.network.CraftingInterfaceConfig;
import org.cyclops.integratedcrafting.capability.network.CraftingNetworkConfig;
import org.cyclops.integratedcrafting.core.CraftingHelpers;
import org.cyclops.integratedcrafting.core.CraftingJobHandler;
import org.cyclops.integratedcrafting.core.CraftingProcessOverrides;
import org.cyclops.integratedcrafting.core.part.PartTypeCraftingBase;
import org.cyclops.integratedcrafting.ingredient.storage.IngredientComponentStorageSlottedInsertProxy;
import org.cyclops.integrateddynamics.api.evaluate.variable.ValueDeseralizationContext;
import org.cyclops.integrateddynamics.api.network.INetwork;
import org.cyclops.integrateddynamics.api.network.INetworkIngredientsChannel;
import org.cyclops.integrateddynamics.api.network.IPartNetwork;
import org.cyclops.integrateddynamics.api.network.IPositionedAddonsNetworkIngredients;
import org.cyclops.integrateddynamics.api.part.PartPos;
import org.cyclops.integrateddynamics.api.part.PartTarget;
import org.cyclops.integrateddynamics.api.part.PrioritizedPartPos;
import org.cyclops.integrateddynamics.capability.network.PositionedAddonsNetworkIngredientsHandlerConfig;
import org.cyclops.integrateddynamics.core.helper.NetworkHelpers;
import org.cyclops.integrateddynamics.core.part.PartStateBase;

public abstract class PartTypeInterfaceCraftingBase<P extends PartTypeInterfaceCraftingBase<P, S>, S extends State<P, S>>
extends PartTypeCraftingBase<P, S> {
    public PartTypeInterfaceCraftingBase(String name) {
        super(name);
    }

    public void afterNetworkReAlive(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.afterNetworkReAlive(network, partNetwork, target, state);
        this.addTargetToNetwork(network, target, state, true);
    }

    public void onNetworkRemoval(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.onNetworkRemoval(network, partNetwork, target, state);
        this.removeTargetFromNetwork(network, target.getTarget(), state);
    }

    public void onNetworkAddition(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.onNetworkAddition(network, partNetwork, target, state);
        this.addTargetToNetwork(network, target, state, true);
    }

    public void setPriorityAndChannel(INetwork network, IPartNetwork partNetwork, PartTarget target, S state, int priority, int channel) {
        this.removeTargetFromNetwork(network, target.getTarget(), state);
        super.setPriorityAndChannel(network, partNetwork, target, state, priority, channel);
        this.addTargetToNetwork(network, target, state, false);
    }

    protected Capability<ICraftingNetwork> getNetworkCapability() {
        return CraftingNetworkConfig.CAPABILITY;
    }

    protected void addTargetToNetwork(INetwork network, PartTarget pos, S state, boolean initialize) {
        network.getCapability(this.getNetworkCapability()).ifPresent(craftingNetwork -> {
            int channelCrafting = state.getChannelCrafting();
            state.setTarget(pos);
            state.setNetworks(network, (ICraftingNetwork)craftingNetwork, NetworkHelpers.getPartNetworkChecked((INetwork)network), channelCrafting, ValueDeseralizationContext.of((Level)pos.getCenter().getPos().getLevel(true)), initialize);
            state.setShouldAddToCraftingNetwork(true);
        });
    }

    protected void removeTargetFromNetwork(INetwork network, PartPos pos, S state) {
        ICraftingNetwork craftingNetwork = ((State)state).getCraftingNetwork();
        if (craftingNetwork != null) {
            network.getCapability(this.getNetworkCapability()).ifPresent(n -> n.removeCraftingInterface(state.getChannelCrafting(), (ICraftingInterface)state));
        }
        ((State)state).setNetworks(null, null, null, -1, null, false);
        ((State)state).setTarget(null);
    }

    public boolean isUpdate(S state) {
        return true;
    }

    public int getMinimumUpdateInterval(S state) {
        return ((State)state).getDefaultUpdateInterval();
    }

    @Nullable
    protected static <T, M> IngredientInstanceWrapper<T, M> insertIntoNetwork(IngredientInstanceWrapper<T, M> wrapper, INetwork network, int channel) {
        IPositionedAddonsNetworkIngredients storageNetwork = wrapper.getComponent().getCapability(PositionedAddonsNetworkIngredientsHandlerConfig.CAPABILITY).map(n -> (IPositionedAddonsNetworkIngredients)n.getStorage(network).orElse(null)).orElse(null);
        if (storageNetwork != null) {
            IIngredientComponentStorage storage = storageNetwork.getChannel(channel);
            Object remaining = storage.insert(wrapper.getInstance(), false);
            if (wrapper.getComponent().getMatcher().isEmpty(remaining)) {
                return null;
            }
            return new IngredientInstanceWrapper(wrapper.getComponent(), remaining);
        }
        return wrapper;
    }

    public void update(INetwork network, IPartNetwork partNetwork, PartTarget target, S state) {
        super.update(network, partNetwork, target, state);
        if (((State)state).getCraftingNetwork() == null) {
            this.addTargetToNetwork(network, target, state, false);
        }
        int channel = ((State)state).getChannelCrafting();
        if (((State)state).shouldAddToCraftingNetwork()) {
            ICraftingNetwork craftingNetwork = (ICraftingNetwork)network.getCapability(this.getNetworkCapability()).orElse(null);
            craftingNetwork.addCraftingInterface(channel, (ICraftingInterface)state);
            ((State)state).setShouldAddToCraftingNetwork(false);
        }
        ((State)state).flushInventoryOutputBuffer(network);
        if (((State)state).getInventoryOutputBuffer().isEmpty()) {
            PartPos targetPos = ((State)state).getTarget().getTarget();
            ((State)state).getCraftingJobHandler().update(network, channel, targetPos);
        }
    }

    public void addDrops(PartTarget target, S state, List<ItemStack> itemStacks, boolean dropMainElement, boolean saveState) {
        for (IngredientInstanceWrapper<?, ?> ingredientInstanceWrapper : ((State)state).getInventoryOutputBuffer()) {
            if (ingredientInstanceWrapper.getComponent() != IngredientComponent.ITEMSTACK) continue;
            itemStacks.add((ItemStack)ingredientInstanceWrapper.getInstance());
        }
        ((State)state).getInventoryOutputBuffer().clear();
        super.addDrops(target, state, itemStacks, dropMainElement, saveState);
    }

    public static abstract class State<P extends PartTypeInterfaceCraftingBase<P, S>, S extends State<P, S>>
    extends PartStateBase<P>
    implements ICraftingInterface,
    ICraftingResultsSink {
        private final CraftingJobHandler craftingJobHandler = new CraftingJobHandler(1, true, CraftingProcessOverrides.REGISTRY.getCraftingProcessOverrides(), this);
        private final List<IngredientInstanceWrapper<?, ?>> inventoryOutputBuffer = Lists.newArrayList();
        private int channelCrafting = 0;
        private PartTarget target = null;
        protected INetwork network = null;
        protected IPartNetwork partNetwork = null;
        protected ICraftingNetwork craftingNetwork = null;
        private int channel = -1;
        protected ValueDeseralizationContext valueDeseralizationContext;
        private boolean shouldAddToCraftingNetwork = false;
        protected Player lastPlayer;

        public void writeToNBT(CompoundTag tag) {
            super.writeToNBT(tag);
            ListTag instanceTags = new ListTag();
            for (IngredientInstanceWrapper<?, ?> instanceWrapper : this.inventoryOutputBuffer) {
                CompoundTag instanceTag = new CompoundTag();
                instanceTag.m_128359_("component", IngredientComponent.REGISTRY.getKey((Object)instanceWrapper.getComponent()).toString());
                instanceTag.m_128365_("instance", instanceWrapper.getComponent().getSerializer().serializeInstance(instanceWrapper.getInstance()));
                instanceTags.add((Object)instanceTag);
            }
            tag.m_128365_("inventoryOutputBuffer", (Tag)instanceTags);
            this.craftingJobHandler.writeToNBT(tag);
            tag.m_128405_("channelCrafting", this.channelCrafting);
        }

        public void readFromNBT(ValueDeseralizationContext valueDeseralizationContext, CompoundTag tag) {
            super.readFromNBT(valueDeseralizationContext, tag);
            this.inventoryOutputBuffer.clear();
            for (Tag instanceTagRaw : tag.m_128437_("inventoryOutputBuffer", 10)) {
                CompoundTag instanceTag = (CompoundTag)instanceTagRaw;
                String componentName = instanceTag.m_128461_("component");
                IngredientComponent component = (IngredientComponent)IngredientComponent.REGISTRY.getValue(new ResourceLocation(componentName));
                this.inventoryOutputBuffer.add(new IngredientInstanceWrapper(component, component.getSerializer().deserializeInstance(instanceTag.m_128423_("instance"))));
            }
            this.craftingJobHandler.readFromNBT(tag);
            this.channelCrafting = tag.m_128451_("channelCrafting");
        }

        protected int getDefaultUpdateInterval() {
            return GeneralConfig.minCraftingInterfaceUpdateFreq;
        }

        public void setChannelCrafting(int channelCrafting) {
            if (this.channelCrafting != channelCrafting) {
                if (this.craftingNetwork != null) {
                    this.craftingNetwork.removeCraftingInterface(this.channelCrafting, this);
                }
                this.channelCrafting = channelCrafting;
                if (this.craftingNetwork != null) {
                    this.craftingNetwork.addCraftingInterface(this.channelCrafting, this);
                }
                this.sendUpdate();
            }
        }

        public int getChannelCrafting() {
            return this.channelCrafting;
        }

        public void setTarget(PartTarget target) {
            this.target = target;
        }

        public PartTarget getTarget() {
            return this.target;
        }

        public void setNetworks(@Nullable INetwork network, @Nullable ICraftingNetwork craftingNetwork, @Nullable IPartNetwork partNetwork, int channel, @Nullable ValueDeseralizationContext valueDeseralizationContext, boolean initialize) {
            this.network = network;
            this.craftingNetwork = craftingNetwork;
            this.partNetwork = partNetwork;
            this.channel = channel;
            this.valueDeseralizationContext = valueDeseralizationContext;
            this.reloadRecipes(initialize);
            if (network != null) {
                this.getCraftingJobHandler().reRegisterObservers(network);
            }
        }

        public void reloadRecipes(boolean initialize) {
        }

        public void setLastPlayer(Player lastPlayer) {
            this.lastPlayer = lastPlayer;
        }

        public ICraftingNetwork getCraftingNetwork() {
            return this.craftingNetwork;
        }

        public int getChannel() {
            return this.channel;
        }

        @Override
        public boolean canScheduleCraftingJobs() {
            return this.getCraftingJobHandler().canScheduleCraftingJobs();
        }

        @Override
        public void scheduleCraftingJob(CraftingJob craftingJob) {
            this.getCraftingJobHandler().scheduleCraftingJob(craftingJob);
        }

        @Override
        public int getCraftingJobsCount() {
            return this.craftingJobHandler.getAllCraftingJobs().size();
        }

        @Override
        public Iterator<CraftingJob> getCraftingJobs() {
            return this.craftingJobHandler.getAllCraftingJobs().values().iterator();
        }

        @Override
        public List<Map<IngredientComponent<?, ?>, List<IPrototypedIngredient<?, ?>>>> getPendingCraftingJobOutputs(int craftingJobId) {
            List pending = (List)this.craftingJobHandler.getProcessingCraftingJobsPendingIngredients().get(craftingJobId);
            if (pending == null) {
                pending = Lists.newArrayList();
            }
            return pending;
        }

        @Override
        public CraftingJobStatus getCraftingJobStatus(ICraftingNetwork network, int channel, int craftingJobId) {
            return this.craftingJobHandler.getCraftingJobStatus(network, channel, craftingJobId);
        }

        @Override
        public void cancelCraftingJob(int channel, int craftingJobId) {
            this.craftingJobHandler.markCraftingJobFinished(craftingJobId);
        }

        @Override
        public PrioritizedPartPos getPosition() {
            return PrioritizedPartPos.of((PartPos)this.getTarget().getCenter(), (int)this.getPriority());
        }

        public CraftingJobHandler getCraftingJobHandler() {
            return this.craftingJobHandler;
        }

        public boolean shouldAddToCraftingNetwork() {
            return this.shouldAddToCraftingNetwork;
        }

        public void setShouldAddToCraftingNetwork(boolean shouldAddToCraftingNetwork) {
            this.shouldAddToCraftingNetwork = shouldAddToCraftingNetwork;
        }

        public List<IngredientInstanceWrapper<?, ?>> getInventoryOutputBuffer() {
            return this.inventoryOutputBuffer;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, INetwork network, IPartNetwork partNetwork, PartTarget target) {
            Object cap;
            IngredientComponent ingredientComponent;
            if (capability == CraftingInterfaceConfig.CAPABILITY) {
                return LazyOptional.of(() -> this).cast();
            }
            if (this.network != null && (ingredientComponent = IngredientComponent.getIngredientComponentForStorageCapability(capability)) != null && (cap = this.wrapStorageCapability(capability, ingredientComponent)) != null) {
                return LazyOptional.of(() -> cap);
            }
            return super.getCapability(capability, network, partNetwork, target);
        }

        protected <C, T, M> C wrapStorageCapability(Capability<C> capability, IngredientComponent<T, M> ingredientComponent) {
            Object storage = CraftingHelpers.getNetworkStorage(this.network, this.channelCrafting, ingredientComponent, false);
            storage = new IngredientComponentStorageSlottedInsertProxy<T, M>(storage);
            return (C)ingredientComponent.getStorageWrapperHandler(capability).wrapStorage(storage);
        }

        @Override
        public <T, M> void addResult(IngredientComponent<T, M> ingredientComponent, T instance) {
            this.getInventoryOutputBuffer().add(new IngredientInstanceWrapper(ingredientComponent, instance));
            if (this.network != null) {
                this.flushInventoryOutputBuffer(this.network);
            }
        }

        public void setIngredientComponentTargetSideOverride(IngredientComponent<?, ?> ingredientComponent, Direction side) {
            if (this.getTarget().getTarget().getSide() == side) {
                this.craftingJobHandler.setIngredientComponentTarget(ingredientComponent, null);
            } else {
                this.craftingJobHandler.setIngredientComponentTarget(ingredientComponent, side);
            }
            this.sendUpdate();
        }

        public Direction getIngredientComponentTargetSideOverride(IngredientComponent<?, ?> ingredientComponent) {
            Direction side = this.craftingJobHandler.getIngredientComponentTarget(ingredientComponent);
            if (side == null) {
                side = this.getTarget().getTarget().getSide();
            }
            return side;
        }

        public void flushInventoryOutputBuffer(INetwork network) {
            boolean changed = false;
            ListIterator<IngredientInstanceWrapper<?, ?>> outputBufferIt = this.getInventoryOutputBuffer().listIterator();
            while (outputBufferIt.hasNext()) {
                IngredientInstanceWrapper<?, ?> oldWrapper = outputBufferIt.next();
                this.forceObservationOnInsertable(oldWrapper);
                IngredientInstanceWrapper<?, ?> newWrapper = PartTypeInterfaceCraftingBase.insertIntoNetwork(oldWrapper, network, this.getChannelCrafting());
                if (newWrapper != oldWrapper) {
                    changed = true;
                }
                if (newWrapper == null) {
                    outputBufferIt.remove();
                    continue;
                }
                outputBufferIt.set(newWrapper);
            }
            if (changed) {
                CraftingHelpers.beforeCalculateCraftingJobs(network, this.getChannelCrafting());
            }
        }

        protected <T, M> void forceObservationOnInsertable(IngredientInstanceWrapper<T, M> oldWrapper) {
            IIngredientMatcher matcher = oldWrapper.getComponent().getMatcher();
            IPositionedAddonsNetworkIngredients ingredientsNetwork = (IPositionedAddonsNetworkIngredients)CraftingHelpers.getIngredientsNetwork(this.network, oldWrapper.getComponent()).orElse(null);
            if (ingredientsNetwork != null) {
                boolean marked = false;
                INetworkIngredientsChannel ingredientsNetworkChannel = ingredientsNetwork.getChannelInternal(this.getChannelCrafting());
                Object instance = oldWrapper.getInstance();
                for (PartPos position : ingredientsNetworkChannel.findNonFullPositions()) {
                    Object instanceOut = ingredientsNetwork.getPositionedStorage(position).insert(instance, true);
                    if (matcher.matchesExactly(instanceOut, instance)) continue;
                    marked = true;
                    instance = instanceOut;
                    ingredientsNetwork.scheduleObservationForced(this.getChannelCrafting(), position);
                    if (!matcher.isEmpty(instance)) continue;
                    break;
                }
                if (marked || ingredientsNetwork.isObservationForcedPending(this.channel)) {
                    ingredientsNetwork.runObserverSync();
                }
            }
        }
    }
}

