/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.snbt;

import dev.ftb.mods.ftblibrary.snbt.SNBTTagProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

public class SNBTCompoundTag
extends CompoundTag {
    private HashMap<String, SNBTTagProperties> properties;
    boolean singleLine = false;

    public static SNBTCompoundTag of(@Nullable Tag tag) {
        if (tag instanceof SNBTCompoundTag) {
            return (SNBTCompoundTag)tag;
        }
        if (tag instanceof CompoundTag) {
            SNBTCompoundTag tag1 = new SNBTCompoundTag();
            for (String s : ((CompoundTag)tag).m_128431_()) {
                tag1.m_128365_(s, ((CompoundTag)tag).m_128423_(s));
            }
            return tag1;
        }
        return new SNBTCompoundTag();
    }

    public SNBTCompoundTag() {
        super(new LinkedHashMap());
    }

    SNBTTagProperties getOrCreateProperties(String key) {
        SNBTTagProperties p;
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        if ((p = this.properties.get(key)) == null) {
            p = new SNBTTagProperties();
            this.properties.put(key, p);
        }
        return p;
    }

    SNBTTagProperties getProperties(String key) {
        SNBTTagProperties p;
        if (this.properties != null && (p = this.properties.get(key)) != null) {
            return p;
        }
        return SNBTTagProperties.DEFAULT;
    }

    public void comment(String key, String ... comment) {
        if (comment.length > 0) {
            this.comment(key, String.join((CharSequence)"\n", comment));
        }
    }

    public void comment(String key, String comment) {
        String s;
        String string = s = comment == null ? "" : comment.trim();
        if (!s.isEmpty()) {
            this.getOrCreateProperties((String)key).comment = comment;
        }
    }

    public String getComment(String key) {
        return this.getProperties((String)key).comment;
    }

    public void singleLine() {
        this.singleLine = true;
    }

    public void singleLine(String key) {
        this.getOrCreateProperties((String)key).singleLine = true;
    }

    public void m_128379_(String key, boolean value) {
        this.getOrCreateProperties((String)key).valueType = value ? 2 : 1;
        super.m_128379_(key, value);
    }

    public boolean isBoolean(String key) {
        int t = this.getProperties((String)key).valueType;
        return t == 2 || t == 1;
    }

    public SNBTCompoundTag getCompound(String string) {
        return SNBTCompoundTag.of(this.m_128423_(string));
    }

    public void putNumber(String key, Number number) {
        if (number instanceof Double) {
            this.m_128347_(key, number.doubleValue());
        } else if (number instanceof Float) {
            this.m_128350_(key, number.floatValue());
        } else if (number instanceof Long) {
            this.m_128356_(key, number.longValue());
        } else if (number instanceof Integer) {
            this.m_128405_(key, number.intValue());
        } else if (number instanceof Short) {
            this.m_128376_(key, number.shortValue());
        } else if (number instanceof Byte) {
            this.m_128344_(key, number.byteValue());
        } else if (number.toString().contains(".")) {
            this.m_128347_(key, number.doubleValue());
        } else {
            this.m_128405_(key, number.intValue());
        }
    }

    public void putNull(String key) {
        this.m_128365_(key, (Tag)EndTag.f_128534_);
    }

    @Nullable
    public ListTag getNullableList(String key, byte type) {
        Tag tag = this.m_128423_(key);
        return tag instanceof ListTag && (((ListTag)tag).isEmpty() || type == 0 || ((ListTag)tag).m_7264_() == type) ? (ListTag)tag : null;
    }

    public <T extends Tag> List<T> getList(String key, Class<T> type) {
        Tag tag = this.m_128423_(key);
        if (!(tag instanceof CollectionTag)) {
            return Collections.emptyList();
        }
        CollectionTag l = (CollectionTag)tag;
        if (l.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Tag> list = new ArrayList<Tag>(l.size());
        for (Tag t : l) {
            if (!type.isAssignableFrom(t.getClass())) continue;
            list.add(t);
        }
        return list;
    }
}

