/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.views;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneParams;
import com.ldtteam.blockui.views.View;
import java.util.Iterator;

public class Group
extends View {
    private int spacing = 0;

    public Group() {
    }

    public Group(PaneParams params) {
        super(params);
        this.spacing = params.getInteger("spacing", this.spacing);
    }

    @Override
    public void adjustChild(Pane child) {
        Pane c;
        int childX = child.getX();
        int childY = this.spacing;
        int childWidth = child.getWidth();
        int childHeight = child.getHeight();
        if (childWidth < 0) {
            childWidth = this.getInteriorWidth();
        } else if (child.getAlignment().isRightAligned()) {
            childX = this.getInteriorWidth() - childWidth - childX;
        } else if (child.getAlignment().isHorizontalCentered()) {
            childX = (this.getInteriorWidth() - childWidth) / 2 + childX;
        }
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext() && (c = (Pane)iterator.next()) != child) {
            childY = c.getY() + c.getHeight() + this.spacing;
        }
        child.setSize(childWidth, childHeight);
        child.setPosition(childX, childY);
    }

    @Override
    public void removeChild(Pane child) {
        super.removeChild(child);
        int formerChildY = child.getY();
        int formerChildHeight = child.getHeight();
        for (Pane c : this.children) {
            if (c.getY() <= formerChildY) continue;
            c.moveBy(0, -formerChildHeight);
        }
    }
}

