/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.blockui.mod.container;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.InputHandler;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.hooks.HookRegistries;
import com.ldtteam.blockui.hooks.TriggerMechanism;
import com.ldtteam.blockui.mod.Log;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.blockui.views.ScrollingList;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.registries.ForgeRegistries;

public class ContainerHook {
    public static TagKey<BlockEntityType<?>> CONTAINER_TAG = ForgeRegistries.BLOCK_ENTITY_TYPES.tags().createTagKey(new ResourceLocation("blockui", "container_gui"));

    public static void init() {
    }

    public static void onContainerGuiOpen(BlockEntity thing, BOWindow window, TriggerMechanism triggerType) {
        Container container;
        Container c;
        if (!Minecraft.m_91087_().m_91091_()) {
            window.findPaneOfTypeByID("items", ScrollingList.class).off();
            window.findPaneOfTypeByID("filter", TextField.class).off();
            window.findPaneOfTypeByID("note", Text.class).setText(Component.m_237115_((String)"blockui.container_gui.client_side_only"));
            return;
        }
        IntegratedServer integratedServer = Minecraft.m_91087_().m_91092_();
        BlockEntity worldBlockEntity = integratedServer.m_129880_(thing.m_58904_().m_46472_()).m_46745_(thing.m_58899_()).m_7702_(thing.m_58899_());
        Object object = worldBlockEntity instanceof Container ? (c = (Container)worldBlockEntity) : (container = worldBlockEntity.m_58903_() == BlockEntityType.f_58920_ ? integratedServer.m_6846_().m_11259_(integratedServer.m_236731_().getId()).m_36327_() : null);
        if (container == null) {
            HookRegistries.BLOCK_ENTITY_HOOKS.unregister(thing.m_58903_(), triggerType);
            Log.getLogger().error("Removing container gui for type \"{}\" because it's not instance of Container class.", (Object)ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)thing.m_58903_()));
        }
        ContainerInfo containerInfo = new ContainerInfo(container);
        if (containerInfo.allItems.isEmpty()) {
            window.findPaneOfTypeByID("items", ScrollingList.class).off();
            window.findPaneOfTypeByID("filter", TextField.class).off();
            window.findPaneOfTypeByID("note", Text.class).setText(Component.m_237115_((String)"blockui.container_gui.empty"));
        } else {
            window.findPaneOfTypeByID("items", ScrollingList.class).setDataProvider(containerInfo);
            window.findPaneOfTypeByID("filter", TextField.class).setHandler(containerInfo);
        }
    }

    private static /* synthetic */ boolean lambda$init$0(BlockEntity thing, TriggerMechanism type) {
        return true;
    }

    private static class ContainerInfo
    implements ScrollingList.DataProvider,
    InputHandler {
        private static final int TICKS_TO_WAIT_FOR_NO_INPUT = 20;
        private final List<ItemInfo> allItems = new ArrayList<ItemInfo>();
        private int ticksLeft = -1;
        private String filter = null;
        private List<ItemInfo> filteredItems = this.allItems;

        private ContainerInfo(Container container) {
            for (int i = 0; i < container.m_6643_(); ++i) {
                ItemStack isContainer = container.m_8020_(i);
                if (isContainer.m_41619_()) continue;
                ItemInfo info = null;
                for (ItemInfo itemInfo : this.allItems) {
                    if (!ItemStack.m_150942_((ItemStack)isContainer, (ItemStack)itemInfo.is)) continue;
                    info = itemInfo;
                    break;
                }
                if (info == null) {
                    this.allItems.add(new ItemInfo(new ItemStack((ItemLike)isContainer.m_41720_()), isContainer.m_41613_()));
                    continue;
                }
                info.count += isContainer.m_41613_();
            }
        }

        @Override
        public void onInput(TextField input) {
            String newFilter = input.getText().strip();
            if (!newFilter.equals(this.filter)) {
                this.ticksLeft = 20;
                this.filter = newFilter;
            }
        }

        @Override
        public int getElementCount() {
            if (this.ticksLeft >= 0) {
                --this.ticksLeft;
            } else if (this.filter == null || this.filter.isEmpty()) {
                this.filteredItems = this.allItems;
            } else {
                Set<String> filterSet = Set.of(this.filter.split(" "));
                this.filteredItems = this.allItems.stream().filter(info -> Set.of(info.is.m_41786_().getString().split(" ")).containsAll(filterSet) || Set.of(ForgeRegistries.ITEMS.getKey((Object)info.is.m_41720_()).m_135815_().split(" _")).containsAll(filterSet)).toList();
            }
            return this.filteredItems.size();
        }

        @Override
        public void updateElement(int index, Pane rowPane) {
            ItemInfo info = this.filteredItems.get(index);
            ItemIcon icon = rowPane.findPaneOfTypeByID("icon", ItemIcon.class);
            if (icon.getItem() != info.is) {
                icon.setItem(info.is);
                rowPane.findPaneOfTypeByID("name", Text.class).setText(info.is.m_41786_());
                rowPane.findPaneOfTypeByID("quantity", Text.class).setText(Component.m_237113_((String)Integer.toString(info.count)));
            }
        }

        private static class ItemInfo {
            private final ItemStack is;
            private int count;

            private ItemInfo(ItemStack is, int count) {
                this.is = is;
                this.count = count;
            }
        }
    }
}

