/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.data.displaystate;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.api.serialization.ISerializer;
import net.darkhax.bookshelf.api.serialization.Serializers;
import net.darkhax.botanypots.data.displaystate.AgingDisplayState;
import net.darkhax.botanypots.data.displaystate.DisplayStateSerializer;
import net.darkhax.botanypots.data.displaystate.SimpleDisplayState;
import net.darkhax.botanypots.data.displaystate.TransitionalDisplayState;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public abstract class DisplayState {
    private static final Map<ResourceLocation, ISerializer<? extends DisplayState>> DISPLAY_TYPES = new HashMap<ResourceLocation, ISerializer<? extends DisplayState>>();
    public static final ISerializer<DisplayState> SERIALIZER = new Serializer();

    @Nullable
    public static ISerializer<? extends DisplayState> getSerializer(ResourceLocation id) {
        return DISPLAY_TYPES.get(id);
    }

    public abstract DisplayStateSerializer<?> getSerializer();

    public static void init() {
        DISPLAY_TYPES.put(SimpleDisplayState.ID, SimpleDisplayState.SERIALIZER);
        DISPLAY_TYPES.put(TransitionalDisplayState.ID, TransitionalDisplayState.SERIALIZER);
        DISPLAY_TYPES.put(AgingDisplayState.ID, AgingDisplayState.SERIALIZER);
    }

    public static class Serializer
    implements ISerializer<DisplayState> {
        public DisplayState fromJSON(JsonElement json) {
            if (json instanceof JsonObject) {
                JsonObject obj = (JsonObject)json;
                ResourceLocation id = (ResourceLocation)Serializers.RESOURCE_LOCATION.fromJSON(obj, "type", (Object)SimpleDisplayState.ID);
                ISerializer<? extends DisplayState> serializer = DISPLAY_TYPES.get(id);
                if (serializer != null) {
                    return (DisplayState)serializer.fromJSON(json);
                }
                throw new JsonParseException("The serializer " + id.toString() + " is unknown.");
            }
            throw new JsonParseException("Expected display state to be a JSON object.");
        }

        public JsonElement toJSON(DisplayState toWrite) {
            JsonElement json = toWrite.getSerializer().toJSON(toWrite);
            if (json instanceof JsonObject) {
                JsonObject obj = (JsonObject)json;
                Serializers.RESOURCE_LOCATION.toJSON(obj, "type", (Object)toWrite.getSerializer().getId());
            }
            return json;
        }

        public DisplayState fromByteBuf(FriendlyByteBuf buffer) {
            ResourceLocation id = (ResourceLocation)Serializers.RESOURCE_LOCATION.fromByteBuf(buffer);
            ISerializer<? extends DisplayState> serializer = DISPLAY_TYPES.get(id);
            if (serializer != null) {
                return (DisplayState)serializer.fromByteBuf(buffer);
            }
            throw new JsonParseException("The serializer " + id.toString() + " is unknown.");
        }

        public void toByteBuf(FriendlyByteBuf buffer, DisplayState toWrite) {
            Serializers.RESOURCE_LOCATION.toByteBuf(buffer, (Object)toWrite.getSerializer().getId());
            toWrite.getSerializer().toByteBuf(buffer, toWrite);
        }

        public Tag toNBT(DisplayState toWrite) {
            return null;
        }

        public DisplayState fromNBT(Tag nbt) {
            return null;
        }
    }
}

