/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.brandonscore.lib.datamanager.AbstractManagedData;
import com.brandon3055.brandonscore.lib.datamanager.DataFlags;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.nbt.CompoundTag;

public class ManagedBool
extends AbstractManagedData<Boolean> {
    private boolean value;
    protected Function<Boolean, Boolean> validator = null;

    public ManagedBool(String name, boolean defaultValue, DataFlags ... flags) {
        super(name, flags);
        this.value = defaultValue;
    }

    public ManagedBool(String name, DataFlags ... flags) {
        this(name, false, flags);
    }

    public boolean set(boolean value) {
        if (!Objects.equals(this.value, value)) {
            boolean set = true;
            boolean prev = this.value;
            this.value = value;
            if (this.dataManager.isClientSide() && this.flags.allowClientControl) {
                this.dataManager.sendToServer(this);
                set = this.ccscsFlag;
            }
            if (set) {
                this.markDirty();
                this.notifyListeners(value);
            } else {
                this.value = prev;
            }
        }
        return this.value;
    }

    public boolean get() {
        return this.value;
    }

    public ManagedBool setValidator(Function<Boolean, Boolean> validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public void validate() {
        if (this.validator != null) {
            this.value = this.validator.apply(this.value);
        }
    }

    @Override
    public void toBytes(MCDataOutput output) {
        output.writeBoolean(this.value);
    }

    @Override
    public void fromBytes(MCDataInput input) {
        this.value = input.readBoolean();
        this.notifyListeners(this.value);
    }

    @Override
    public void toNBT(CompoundTag compound) {
        compound.m_128379_(this.name, this.value);
    }

    @Override
    public void fromNBT(CompoundTag compound) {
        this.value = compound.m_128471_(this.name);
        this.notifyListeners(this.value);
    }

    public String toString() {
        return this.getClass().getSimpleName() + ":[" + this.getName() + "=" + this.value + "]";
    }

    public boolean invert() {
        return this.set(!this.value);
    }
}

