/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.shader;

import codechicken.lib.render.shader.CCShaderInstance;
import codechicken.lib.render.shader.CCUniform;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.eventbus.api.IEventBus;

public class BCShader<T extends BCShader<T>> {
    private final ResourceLocation location;
    private final VertexFormat format;
    private final List<Consumer<T>> applyCallbacks = new LinkedList<Consumer<T>>();
    protected CCShaderInstance shaderInstance;
    protected CCUniform modelMatUniform;
    protected CCUniform timeUniform;
    private CCUniform decayUniform;

    public BCShader(ResourceLocation location, VertexFormat format) {
        this.location = location;
        this.format = format;
    }

    public final void register(IEventBus bus) {
        bus.addListener(this::onRegisterShaders);
    }

    public final T onShaderApplied(Consumer<T> cons) {
        this.applyCallbacks.add(cons);
        return (T)this;
    }

    public final boolean isLoaded() {
        return this.shaderInstance != null;
    }

    public final CCShaderInstance getShaderInstance() {
        return Objects.requireNonNull(this.shaderInstance, "Shader not loaded yet.");
    }

    public final CCUniform getModelMatUniform() {
        return Objects.requireNonNull(this.modelMatUniform, this.missingUniformMessage("ModelMat"));
    }

    public final boolean hasModelMatUniform() {
        return this.modelMatUniform != null;
    }

    public final CCUniform getTimeUniform() {
        return Objects.requireNonNull(this.timeUniform, this.missingUniformMessage("Time"));
    }

    public final boolean hasTimeUniform() {
        return this.timeUniform != null;
    }

    public final CCUniform getDecayUniform() {
        return Objects.requireNonNull(this.decayUniform, this.missingUniformMessage("Decay"));
    }

    public final boolean hasDecayUniform() {
        return this.decayUniform != null;
    }

    private void onRegisterShaders(RegisterShadersEvent event) {
        event.registerShader((ShaderInstance)CCShaderInstance.create((ResourceProvider)event.getResourceProvider(), (ResourceLocation)this.location, (VertexFormat)this.format), e -> {
            this.shaderInstance = (CCShaderInstance)e;
            this.onShaderLoaded();
            this.shaderInstance.onApply(() -> {
                for (Consumer<BCShader> consumer : this.applyCallbacks) {
                    consumer.accept(this);
                }
            });
        });
    }

    protected void onShaderLoaded() {
        this.modelMatUniform = this.shaderInstance.getUniform("ModelMat");
        this.timeUniform = this.shaderInstance.getUniform("Time");
        this.decayUniform = this.shaderInstance.getUniform("Decay");
    }

    protected final String missingUniformMessage(String name) {
        if (this.shaderInstance == null) {
            return "Shader not yet loaded.";
        }
        return "Shader does not have '" + name + "' uniform.";
    }
}

