/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui;

import codechicken.lib.gui.modular.elements.GuiEnergyBar;
import codechicken.lib.gui.modular.elements.GuiRectangle;
import codechicken.lib.gui.modular.lib.GuiRender;
import codechicken.lib.gui.modular.lib.geometry.GuiParent;
import codechicken.lib.gui.modular.sprite.Material;
import codechicken.lib.render.buffer.TransformingVertexConsumer;
import codechicken.lib.util.FormatUtil;
import com.brandon3055.brandonscore.api.power.IOInfo;
import com.brandon3055.brandonscore.api.power.IOPStorage;
import com.brandon3055.brandonscore.client.BCGuiTextures;
import com.brandon3055.brandonscore.client.shader.BCShaders;
import com.brandon3055.brandonscore.utils.EnergyUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderStateShard;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShaderEnergyBar
extends GuiEnergyBar {
    private static final RenderType SHADER_TYPE = RenderType.m_173215_((String)"starfield", (VertexFormat)DefaultVertexFormat.f_85814_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (int)256, (boolean)false, (boolean)false, (RenderType.CompositeState)RenderType.CompositeState.m_110628_().m_173292_(new RenderStateShard.ShaderStateShard(() -> BCShaders.energyBarShader)).m_173290_((RenderStateShard.EmptyTextureStateShard)new RenderStateShard.TextureStateShard(BCGuiTextures.getAtlasHolder().atlasLocation(), false, false)).m_110691_(false));
    private Supplier<Boolean> shaderEnabled = () -> true;
    private Supplier<Boolean> disabled = () -> false;

    public ShaderEnergyBar(@NotNull GuiParent<?> parent) {
        super(parent);
    }

    public static BiFunction<Long, Long, List<Component>> opEnergyFormatter(@Nullable IOPStorage storage) {
        return (energy, capacity) -> {
            ArrayList<MutableComponent> tooltip = new ArrayList<MutableComponent>();
            tooltip.add(Component.m_237115_((String)"mod_gui.brandonscore.energy_bar.operational_potential").m_130940_(ChatFormatting.DARK_AQUA));
            boolean shift = Screen.m_96638_();
            tooltip.add(Component.m_237115_((String)"mod_gui.brandonscore.energy_bar.capacity").m_130940_(ChatFormatting.GOLD).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)(shift ? FormatUtil.addCommas((long)capacity) : FormatUtil.formatNumber((long)capacity))).m_130940_(ChatFormatting.GRAY).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"mod_gui.brandonscore.energy_bar.op").m_130940_(ChatFormatting.GRAY))));
            tooltip.add(Component.m_237115_((String)"mod_gui.brandonscore.energy_bar.stored").m_130940_(ChatFormatting.GOLD).m_130946_(" ").m_7220_((Component)Component.m_237113_((String)(shift ? FormatUtil.addCommas((long)energy) : FormatUtil.formatNumber((long)energy))).m_130940_(ChatFormatting.GRAY)).m_130946_(" ").m_7220_((Component)Component.m_237115_((String)"mod_gui.brandonscore.energy_bar.op").m_130940_(ChatFormatting.GRAY)).m_7220_((Component)Component.m_237113_((String)String.format(" (%.2f%%)", (double)energy.longValue() / (double)capacity.longValue() * 100.0)).m_130940_(ChatFormatting.GRAY)));
            if (storage != null && storage.getIOInfo() != null) {
                IOInfo ioInfo = storage.getIOInfo();
                if (Screen.m_96638_()) {
                    tooltip.add(Component.m_237115_((String)"mod_gui.brandonscore.energy_bar.input").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)" +").m_130940_(ChatFormatting.GREEN).m_130946_(Utils.formatNumber(ioInfo.currentInput()))));
                    tooltip.add(Component.m_237115_((String)"mod_gui.brandonscore.energy_bar.output").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)" -").m_130940_(ChatFormatting.RED).m_130946_(Utils.formatNumber(ioInfo.currentOutput()))));
                } else {
                    long io = ioInfo.currentInput() - ioInfo.currentOutput();
                    tooltip.add(Component.m_237115_((String)"mod_gui.brandonscore.energy_bar.io").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)((io > 0L ? " +" : " ") + io + " ")).m_130940_(io > 0L ? ChatFormatting.GREEN : (io < 0L ? ChatFormatting.RED : ChatFormatting.GRAY)).m_7220_((Component)Component.m_237115_((String)"mod_gui.brandonscore.energy_bar.op"))));
                }
            }
            return tooltip;
        };
    }

    public ShaderEnergyBar setShaderEnabled(Supplier<Boolean> shaderEnabled) {
        this.shaderEnabled = shaderEnabled;
        return this;
    }

    public GuiEnergyBar setDisabled(Supplier<Boolean> disabled) {
        this.disabled = disabled;
        return this;
    }

    public ShaderEnergyBar bindOpStorage(@Nullable IOPStorage storage) {
        if (storage == null) {
            this.setEnergy(0L).setCapacity(0L);
        } else {
            this.setEnergy(storage::getOPStored).setCapacity(storage::getMaxOPStored);
        }
        return this;
    }

    public ShaderEnergyBar setItemSupplier(Supplier<ItemStack> stackSupplier) {
        this.setCapacity(() -> EnergyUtils.isEnergyItem((ItemStack)stackSupplier.get()) ? EnergyUtils.getMaxEnergyStored((ItemStack)stackSupplier.get()) : 0L);
        this.setEnergy(() -> EnergyUtils.isEnergyItem((ItemStack)stackSupplier.get()) ? EnergyUtils.getEnergyStored((ItemStack)stackSupplier.get()) : 0L);
        return this;
    }

    public void renderBackground(GuiRender render, double mouseX, double mouseY, float partialTicks) {
        double charge;
        boolean horizontal = this.xSize() > this.ySize();
        double barLength = horizontal ? this.xSize() : this.ySize();
        double barWidth = horizontal ? this.ySize() : this.xSize();
        double d = charge = this.getCapacity() <= 0L ? 0.0 : (double)this.getEnergy() / (double)this.getCapacity();
        if (Double.isNaN(charge)) {
            charge = 0.0;
        }
        double draw = charge * barLength;
        double posY = this.yMin();
        double posX = this.xMin();
        if (horizontal) {
            double x = posY;
            posY = posX;
            posX = x;
            render.pose().m_85836_();
            render.pose().m_85837_(barLength + posY * 2.0, 0.0, 0.0);
            render.pose().m_252781_(Axis.f_252403_.m_252977_(90.0f));
        }
        MultiBufferSource.BufferSource getter = render.buffers();
        if (this.disabled.get().booleanValue()) {
            render.rect(posX, posY, barWidth, barLength, -16777216);
        } else if (!this.shaderEnabled.get().booleanValue()) {
            Material matBase = BCGuiTextures.get("bars/energy_empty");
            Material matOverlay = BCGuiTextures.get("bars/energy_full");
            TransformingVertexConsumer shaderConsumer = new TransformingVertexConsumer(matBase.buffer((MultiBufferSource)getter, GuiRender::texColType), render.pose());
            this.sliceSprite((VertexConsumer)shaderConsumer, posX, posY, barWidth, barLength, matBase.sprite());
            this.sliceSprite((VertexConsumer)shaderConsumer, posX, posY + barLength - draw, barWidth, draw, matOverlay.sprite());
        } else {
            Rectangle rect = this.toScreenSpace(this.xMin(), this.yMin(), this.xSize(), this.ySize());
            BCShaders.energyBarCharge.glUniform1f((float)charge * 1.01f);
            BCShaders.energyBarEPos.glUniform2i(rect.x, rect.y);
            BCShaders.energyBarESize.glUniform2i(rect.width, rect.height);
            BCShaders.energyBarScreenSize.glUniform2i(this.mc().m_91268_().m_85441_(), this.mc().m_91268_().m_85442_());
            TransformingVertexConsumer shaderConsumer = new TransformingVertexConsumer(getter.m_6299_(SHADER_TYPE), render.pose());
            this.drawShaderRect((VertexConsumer)shaderConsumer, posX, posY, barWidth, barLength);
        }
        getter.m_109911_();
        if (horizontal) {
            render.pose().m_85849_();
        }
    }

    private void drawShaderRect(VertexConsumer buffer, double x, double y, double width, double height) {
        buffer.m_5483_(x, y + height, 0.0).m_5752_();
        buffer.m_5483_(x + width, y + height, 0.0).m_5752_();
        buffer.m_5483_(x + width, y, 0.0).m_5752_();
        buffer.m_5483_(x, y, 0.0).m_5752_();
    }

    public void sliceSprite(VertexConsumer buffer, double xPos, double yPos, double xSize, double ySize, TextureAtlasSprite sprite) {
        float texU = sprite.m_118409_();
        float texV = sprite.m_118411_();
        int texWidth = sprite.m_245424_().m_246492_();
        int texHeight = sprite.m_245424_().m_245330_();
        float uScale = (sprite.m_118410_() - texU) / (float)texWidth;
        float vScale = (sprite.m_118412_() - texV) / (float)texHeight;
        for (double i = 0.0; i < ySize; i += Math.min((double)(texHeight - 2), ySize - i)) {
            double partSize = Math.min((double)texHeight, ySize - i);
            this.bufferRect(buffer, xPos, yPos + ySize - i, xSize, -partSize, sprite.m_118409_(), sprite.m_118411_(), (float)xSize * uScale, (float)partSize * vScale);
        }
    }

    private void bufferRect(VertexConsumer buffer, double x, double y, double width, double height, float minU, float minV, float tWidth, float tHeight) {
        buffer.m_5483_(x, y + height, 0.0).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, minV + tHeight).m_5752_();
        buffer.m_5483_(x + width, y + height, 0.0).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU + tWidth, minV + tHeight).m_5752_();
        buffer.m_5483_(x + width, y, 0.0).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU + tWidth, minV).m_5752_();
        buffer.m_5483_(x, y, 0.0).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(minU, minV).m_5752_();
    }

    public Rectangle toScreenSpace(double xPos, double yPos, double xSize, double ySize) {
        double yResScale = (double)this.mc().m_91268_().m_85442_() / (double)this.scaledScreenHeight();
        double xResScale = (double)this.mc().m_91268_().m_85441_() / (double)this.scaledScreenWidth();
        double scaledWidth = xSize * xResScale;
        double scaledHeight = ySize * yResScale;
        int x = (int)(xPos * xResScale);
        int y = (int)((double)this.mc().m_91268_().m_85442_() - yPos * yResScale - scaledHeight);
        return new Rectangle(x, y, (int)scaledWidth, (int)scaledHeight);
    }

    public record EnergyBar(GuiRectangle container, ShaderEnergyBar bar) {
    }
}

