/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.tile.exchange;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.items.IItemHandler;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.config.ActiveCircleConfig;
import stepsword.mahoutsukai.config.MTConfig;
import stepsword.mahoutsukai.tile.MahoujinTileEntity;
import stepsword.mahoutsukai.tile.ModTileEntities;
import stepsword.mahoutsukai.util.EffectUtil;
import stepsword.mahoutsukai.util.Utils;

public class DurabilityExchangeMahoujinTileEntity
extends MahoujinTileEntity
implements BlockEntityTicker<DurabilityExchangeMahoujinTileEntity> {
    private int tickCounter = 0;

    public DurabilityExchangeMahoujinTileEntity(BlockPos p, BlockState bs) {
        super((BlockEntityType)ModTileEntities.durabilityExchange.get(), p, bs);
    }

    public void tick(Level level, BlockPos blockPos, BlockState blockState, DurabilityExchangeMahoujinTileEntity blockEntity) {
        if (!level.f_46443_) {
            if (this.tickCounter == MTConfig.DURABILITY_EXCHANGE_BLOCK_CYCLE) {
                if (ActiveCircleConfig.tryToOperate(this, this.getCasterUUID())) {
                    this.consumeDurabilityOnTop();
                    this.consumeDurabilityBelow();
                }
                this.tickCounter = 0;
            }
            ++this.tickCounter;
        }
    }

    public void consumeDurabilityBelow() {
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_7918_(0, -1, 0));
        int restored = 0;
        if (te != null && this.getCaster() != null) {
            IMahou mahou = Utils.getPlayerMahou(this.getCaster());
            IItemHandler invCap = Utils.getInventory(te);
            if (invCap != null && mahou != null) {
                boolean flag = false;
                for (int i = 0; i < invCap.getSlots(); ++i) {
                    boolean unbreakable;
                    ItemStack stack = invCap.getStackInSlot(i);
                    CompoundTag nbt = stack.m_41783_();
                    boolean bl = unbreakable = nbt != null && nbt.m_128441_("Unbreakable") && nbt.m_128471_("Unbreakable");
                    if (!stack.m_41619_() && stack.m_41720_().m_41465_() && !unbreakable && stack.m_41773_() < stack.m_41776_() && !this.blacklisted(stack)) {
                        while (stack.m_41773_() < stack.m_41776_()) {
                            if (mahou.getStoredMana() >= mahou.getMaxMana()) {
                                mahou.setStoredMana(mahou.getMaxMana());
                                flag = true;
                                break;
                            }
                            int tmp = stack.m_41773_();
                            int mana_restored = 1;
                            double tax = DurabilityExchangeMahoujinTileEntity.computeTax(stack);
                            if (tax < 1.0 && tax > 0.0) {
                                mana_restored = (int)(1.0 / tax);
                                tax = 1.0;
                            }
                            stack.m_41622_((int)tax, (LivingEntity)this.getCaster(), a -> {});
                            stack = invCap.getStackInSlot(i);
                            if (stack.m_41773_() <= tmp) break;
                            mahou.setStoredMana(Math.min(mahou.getMaxMana(), mahou.getStoredMana() + mana_restored));
                            if (++restored < MTConfig.DURABILITY_EXCHANGE_MANA_GAIN_CAP) continue;
                            flag = true;
                            break;
                        }
                    }
                    if (flag) break;
                }
            }
        }
    }

    public static double computeTax(ItemStack stack) {
        double ret = MTConfig.DURABILITY_EXCHANGE_EFFICIENCY;
        double currDurability = stack.m_41776_() - stack.m_41773_();
        currDurability = Math.max(currDurability, 0.0);
        List<? extends Double> rates = MTConfig.DURABILITY_EXCHANGE_TAX_RATES;
        List<? extends Double> brackets = MTConfig.DURABILITY_EXCHANGE_TAX_BRACKETS;
        double highestbracket = 0.0;
        int tmpi = -1;
        if (brackets.size() > 0) {
            for (int i = 0; i < brackets.size(); ++i) {
                if (!(brackets.get(i) > highestbracket) || !(currDurability >= brackets.get(i))) continue;
                highestbracket = brackets.get(i);
                tmpi = i;
            }
            if (tmpi >= 0 && tmpi < rates.size()) {
                ret = Math.min(rates.get(tmpi) * currDurability, currDurability);
            }
        }
        return ret;
    }

    public void consumeDurabilityOnTop() {
        List lst = this.f_58857_.m_45976_(ItemEntity.class, new AABB((double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (double)(this.f_58858_.m_123341_() + 1), (double)(this.f_58858_.m_123342_() + 1), (double)(this.f_58858_.m_123343_() + 1)));
        boolean flag = false;
        int restored = 0;
        if (this.getCaster() != null) {
            IMahou mahou = Utils.getPlayerMahou(this.getCaster());
            if (!lst.isEmpty() && mahou != null) {
                for (ItemEntity tmp : lst) {
                    boolean unbreakable;
                    ItemStack stack = tmp.m_32055_();
                    CompoundTag nbt = stack.m_41783_();
                    boolean bl = unbreakable = nbt != null && nbt.m_128441_("Unbreakable") && nbt.m_128471_("Unbreakable");
                    if (!unbreakable && stack.m_41720_().m_41465_() && stack.m_41773_() < stack.m_41776_() && !this.blacklisted(stack)) {
                        while (stack.m_41773_() < stack.m_41776_()) {
                            if (mahou.getStoredMana() >= mahou.getMaxMana()) {
                                mahou.setStoredMana(mahou.getMaxMana());
                                flag = true;
                                break;
                            }
                            int tmp2 = stack.m_41773_();
                            int mana_restored = 1;
                            double tax = DurabilityExchangeMahoujinTileEntity.computeTax(stack);
                            if (tax < 1.0 && tax > 0.0) {
                                mana_restored = (int)(1.0 / tax);
                                tax = 1.0;
                            }
                            stack.m_41622_((int)tax, (LivingEntity)this.getCaster(), a -> {});
                            if (stack.m_41773_() <= tmp2) break;
                            mahou.setStoredMana(Math.min(mahou.getMaxMana(), mahou.getStoredMana() + mana_restored));
                            ++restored;
                            if (stack.m_41773_() >= stack.m_41776_()) {
                                tmp.m_146870_();
                            }
                            if (restored < MTConfig.DURABILITY_EXCHANGE_MANA_GAIN_CAP) continue;
                            flag = true;
                            break;
                        }
                    }
                    if (!flag) continue;
                    break;
                }
            }
        }
    }

    public boolean blacklisted(ItemStack stack) {
        boolean itemBlacklisted = EffectUtil.inItemBlacklist(stack.m_41720_(), MTConfig.DURABILITY_EXCHANGE_BLACKLIST);
        boolean enchantBlacklisted = false;
        for (Enchantment s : EnchantmentHelper.m_44831_((ItemStack)stack).keySet()) {
            enchantBlacklisted = enchantBlacklisted || EffectUtil.inEnchantBlacklist(s, MTConfig.DURABILITY_EXCHANGE_BLACKLIST);
        }
        return itemBlacklisted || enchantBlacklisted;
    }
}

