/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.render.entity.kodoku;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class ModelKodoku<T extends Entity>
extends HierarchicalModel<T> {
    public static ModelLayerLocation KODOKU_LAYER = new ModelLayerLocation(new ResourceLocation("mahoutsukai", "kodoku"), "main");
    private final ModelPart root;
    private final ModelPart[] wormparts = new ModelPart[5];
    List<ModelPart> parts = new ArrayList<ModelPart>();
    private static final int[][] WORM_BOX_LENGTH = new int[][]{{2, 2, 1}, {3, 3, 2}, {4, 4, 3}, {3, 3, 1}, {2, 2, 1}};
    private static final int[][] WORM_TEXTURE_POSITIONS = new int[][]{{0, 0}, {4, 4}, {9, 9}, {16, 16}, {13, 13}};

    public ModelKodoku(ModelPart r) {
        this.root = r;
        Arrays.setAll(this.wormparts, z -> r.m_171324_(ModelKodoku.getSegmentName(z)));
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        float[] afloat = new float[7];
        float f = -3.5f;
        for (int i = 0; i < 5; ++i) {
            partdefinition.m_171599_(ModelKodoku.getSegmentName(i), CubeListBuilder.m_171558_().m_171514_(WORM_TEXTURE_POSITIONS[i][0], WORM_TEXTURE_POSITIONS[i][1]).m_171481_((float)WORM_BOX_LENGTH[i][0] * -0.4f, 0.0f, (float)WORM_BOX_LENGTH[i][2] * -0.4f, (float)WORM_BOX_LENGTH[i][0], (float)WORM_BOX_LENGTH[i][1], (float)WORM_BOX_LENGTH[i][2]), PartPose.m_171419_((float)0.0f, (float)(24 - WORM_BOX_LENGTH[i][1]), (float)f));
            afloat[i] = f;
            if (i >= 4) continue;
            f += (float)(WORM_BOX_LENGTH[i][2] + WORM_BOX_LENGTH[i + 1][2]) * 0.5f;
        }
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    private static String getLayerName(int p_170930_) {
        return "layer" + p_170930_;
    }

    private static String getSegmentName(int b) {
        return "segment" + b;
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    public void m_6973_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        for (int i = 0; i < this.wormparts.length; ++i) {
            if (limbSwingAmount != -1.0f) {
                this.wormparts[i].f_104204_ = Mth.m_14089_((float)(ageInTicks * 0.4f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * 0.05f * (float)(1 + Math.abs(i - 2));
                this.wormparts[i].f_104200_ = Mth.m_14031_((float)(ageInTicks * 0.4f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * 0.2f * (float)Math.abs(i - 2);
                continue;
            }
            this.wormparts[i].f_104204_ = Mth.m_14089_((float)(ageInTicks * 0.4f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * 0.05f * (float)(1 + Math.abs(i - 2) + 90);
            this.wormparts[i].f_104200_ = Mth.m_14031_((float)(ageInTicks * 0.4f + (float)i * 0.15f * (float)Math.PI)) * (float)Math.PI * 0.2f * (float)Math.abs(i - 2);
        }
    }
}

