/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.capability.settingsmahou.ISettingsMahou;
import stepsword.mahoutsukai.capability.settingsmahou.SettingsMahou;
import stepsword.mahoutsukai.networking.ClientPacketHandler;
import stepsword.mahoutsukai.util.Utils;

public class SettingsMahouPacket {
    ISettingsMahou mahou;

    public SettingsMahouPacket() {
    }

    public SettingsMahouPacket(ISettingsMahou mahou) {
        this.mahou = mahou;
    }

    public void fromBytes(ByteBuf buf) {
        this.mahou = new SettingsMahou();
        int sz = buf.readInt();
        for (int i = 0; i < sz; ++i) {
            this.mahou.setIntSettings(buf.readInt(), Utils.readIntListFromBuffer(buf));
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.mahou.getIntSettingsKeySet().size());
        for (Integer i : this.mahou.getIntSettingsKeySet()) {
            buf.writeInt(i.intValue());
            Utils.writeIntListToBuffer(buf, this.mahou.getIntSettings(i));
        }
    }

    public static void encode(SettingsMahouPacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static SettingsMahouPacket decode(FriendlyByteBuf buf) {
        SettingsMahouPacket msg = new SettingsMahouPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(SettingsMahouPacket message, Supplier<NetworkEvent.Context> context) {
        ClientPacketHandler.mahouPacketHandler(message);
        context.get().setPacketHandled(true);
    }
}

