/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.item.spells.secret.ripper.TheRipper;

public class RipperUseEntityPacket {
    InteractionHand hand = InteractionHand.MAIN_HAND;
    int id = 0;

    public RipperUseEntityPacket() {
    }

    public RipperUseEntityPacket(InteractionHand h, int i) {
        this.hand = h;
        this.id = i;
    }

    public void fromBytes(ByteBuf buf) {
        this.id = buf.readInt();
        int h = buf.readInt();
        this.hand = h >= 0 && h < InteractionHand.values().length ? InteractionHand.values()[h] : InteractionHand.MAIN_HAND;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.id);
        buf.writeInt(this.hand.ordinal());
    }

    public static void encode(RipperUseEntityPacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static RipperUseEntityPacket decode(FriendlyByteBuf buf) {
        RipperUseEntityPacket msg = new RipperUseEntityPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(RipperUseEntityPacket message, Supplier<NetworkEvent.Context> context) {
        ServerPlayer player = context.get().getSender();
        if (player != null) {
            ServerLevel ServerLevel2 = (ServerLevel)player.m_9236_();
            Entity entity = ServerLevel2.m_6815_(message.id);
            player.m_9243_();
            if (entity instanceof LivingEntity) {
                boolean flag = BehaviorUtils.m_22667_((LivingEntity)player, (LivingEntity)((LivingEntity)entity));
                double d0 = 36.0;
                if (!flag) {
                    d0 = 9.0;
                }
                if (player.m_20280_(entity) < d0) {
                    if (entity instanceof ItemEntity || entity instanceof ExperienceOrb || entity instanceof AbstractArrow || entity == player) {
                        return;
                    }
                    TheRipper.attackTargetEntityWithCurrentItem(entity, (Player)player, message.hand);
                }
            }
        }
        context.get().setPacketHandled(true);
    }
}

