/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.item.replica.Replica;

public class ReplicaSwitchPacket {
    int slot;

    public ReplicaSwitchPacket() {
    }

    public ReplicaSwitchPacket(int s) {
        this.slot = s;
    }

    public void fromBytes(ByteBuf buf) {
        this.slot = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slot);
    }

    public static void encode(ReplicaSwitchPacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static ReplicaSwitchPacket decode(FriendlyByteBuf buf) {
        ReplicaSwitchPacket msg = new ReplicaSwitchPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(ReplicaSwitchPacket message, Supplier<NetworkEvent.Context> context) {
        ReplicaSwitchPacket.handleReplicaSwitch(message, (Player)context.get().getSender());
        context.get().setPacketHandled(true);
    }

    public static void handleReplicaSwitch(ReplicaSwitchPacket message, Player player) {
        ItemStack stack = player.m_21205_();
        if (stack != null && !stack.m_41619_() && stack.m_41720_() instanceof Replica) {
            if (message.slot == 6) {
                Replica.clearDamageTypes(stack);
            } else {
                Replica.setSelectedSlot(stack, message.slot);
            }
        }
    }
}

