/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.networking.ClientPacketHandler;
import stepsword.mahoutsukai.util.Utils;

public class DataManagerPacket {
    public BlockPos pos;
    public List<SynchedEntityData.DataValue<?>> dataManagerEntries;

    public DataManagerPacket() {
    }

    public DataManagerPacket(BlockPos pos, List<SynchedEntityData.DataValue<?>> dataManagerEntries) {
        this.pos = pos;
        this.dataManagerEntries = dataManagerEntries;
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        FriendlyByteBuf buffer = new FriendlyByteBuf(buf);
        try {
            short i;
            ArrayList list = new ArrayList();
            while ((i = buf.readUnsignedByte()) != 255) {
                list.add(SynchedEntityData.DataValue.m_252860_((FriendlyByteBuf)buffer, (int)i));
            }
            this.dataManagerEntries = list;
        }
        catch (Exception e) {
            Utils.err(e.toString());
        }
    }

    public void toBytes(ByteBuf buf) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(buf);
        buf.writeInt(this.pos.m_123341_());
        buf.writeInt(this.pos.m_123342_());
        buf.writeInt(this.pos.m_123343_());
        for (SynchedEntityData.DataValue<?> datavalue : this.dataManagerEntries) {
            datavalue.m_252897_(buffer);
        }
        buffer.writeByte(255);
    }

    public static void encode(DataManagerPacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static DataManagerPacket decode(FriendlyByteBuf buf) {
        DataManagerPacket msg = new DataManagerPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(DataManagerPacket message, Supplier<NetworkEvent.Context> context) {
        ClientPacketHandler.updateTE(message);
        context.get().setPacketHandled(true);
    }
}

