/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.networking;

import io.netty.buffer.ByteBuf;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;
import stepsword.mahoutsukai.networking.ClientPacketHandler;

public class AuthorityPacket {
    int entityids;
    boolean authority;

    public AuthorityPacket() {
    }

    public AuthorityPacket(int e, boolean b) {
        this.entityids = e;
        this.authority = b;
    }

    public void fromBytes(ByteBuf buf) {
        this.entityids = buf.readInt();
        this.authority = buf.readBoolean();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityids);
        buf.writeBoolean(this.authority);
    }

    public static void encode(AuthorityPacket msg, FriendlyByteBuf buf) {
        msg.toBytes((ByteBuf)buf);
    }

    public static AuthorityPacket decode(FriendlyByteBuf buf) {
        AuthorityPacket msg = new AuthorityPacket();
        msg.fromBytes((ByteBuf)buf);
        return msg;
    }

    public static void handle(AuthorityPacket message, Supplier<NetworkEvent.Context> context) {
        ClientPacketHandler.updateAuthority(message);
        context.get().setPacketHandled(true);
    }
}

