/*
 * Decompiled with CFR 0.152.
 */
package stepsword.mahoutsukai.capability.mahou;

import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import stepsword.mahoutsukai.block.spells.MahoujinRecipeRegistrar;
import stepsword.mahoutsukai.capability.mahou.IMahou;
import stepsword.mahoutsukai.util.BlockDim;
import stepsword.mahoutsukai.util.UnorderedList;

public class MahouStorage {
    private static String PLAYER_STORED_MANA = "MAHOUTSUKAI_PLAYER_STORED_MANA";
    private static String PLAYER_MAX_MANA = "MAHOUTSUKAI_PLAYER_MAX_MANA";
    private static String PLAYER_CHARGE_RATE = "MAHOUTSUKAI_PLAYER_CHARGE_RATE";
    private static String PLAYER_MANA_TO_USE_COUNTER = "MAHOUTSUKAI_MANA_UP_COUNTER";
    private static String PLAYER_FULL_MANA_FLAG = "MAHOUTSUKAI_MANA_FULL";
    private static String PLAYER_ENEMY = "MAHOUTSUKAI_PLAYER_ENEMY";
    private static String PLAYER_SAVED_SPAWN_X = "MAHOUTSUKAI_PLAYER_SAVED_SPAWN_X";
    private static String PLAYER_SAVED_SPAWN_Y = "MAHOUTSUKAI_PLAYER_SAVED_SPAWN_Y";
    private static String PLAYER_SAVED_SPAWN_Z = "MAHOUTSUKAI_PLAYER_SAVED_SPAWN_Z";
    private static String PLAYER_OLD_DIMENSION = "MAHOUTSUKAI_PLAYER_OLD_DIMENSION";
    private static String PLAYER_MARBLE_SPAWN_X = "MAHOUTSUKAI_PLAYER_MARBLE_SPAWN_X";
    private static String PLAYER_MARBLE_SPAWN_Y = "MAHOUTSUKAI_PLAYER_MARBLE_SPAWN_Y";
    private static String PLAYER_MARBLE_SPAWN_Z = "MAHOUTSUKAI_PLAYER_MARBLE_SPAWN_Z";
    private static String MEMORIZED_EDMTE_X = "MAHOUTSUKAI_PLAYER_MEMORIZED_EDMTE_X";
    private static String MEMORIZED_EDMTE_Y = "MAHOUTSUKAI_PLAYER_MEMORIZED_EDMTE_Y";
    private static String MEMORIZED_EDMTE_Z = "MAHOUTSUKAI_PLAYER_MEMORIZED_EDMTE_Z";
    private static String MEMORIZED_EDMTE_D = "MAHOUTSUKAI_PLAYER_MEMORIZED_EDMTE_D";
    private static String MENTAL_DISPLACEMENT_X = "MAHOUTSUKAI_PLAYER_MENTAL_DISPLACEMENT_ORIGINAL_X";
    private static String MENTAL_DISPLACEMENT_Y = "MAHOUTSUKAI_PLAYER_MENTAL_DISPLACEMENT_ORIGINAL_Y";
    private static String MENTAL_DISPLACEMENT_Z = "MAHOUTSUKAI_PLAYER_MENTAL_DISPLACEMENT_ORIGINAL_Z";
    private static String PLAYER_LAST_ARROW = "MAHOUTSUKAI_PLAYER_LAST_ARROW";
    private static String PROTECTIVE_DISPLACEMENT_USES = "MAHOUTSUKAI_PLAYER_PROTECTIVE_DISPLACEMENT_USES";
    private static String DAMAGE_EXCHANGE_USES = "MAHOUTSUKAI_PLAYER_DAMAGE_EXCHANGE_USES";
    private static String DEATH_COLLECTION_USES_LEFT = "MAHOUTSUKAI_PLAYER_DEATH_COLLECTION_USES_LEFT";
    private static String IS_POSSESSING = "MAHOUTSUKAI_PLAYER_POSSESSING";
    private static String DAMAGE_REPLICATION_TARGET = "MAHOUTSUKAI_PLAYER_DAMAGE_REPLICATION_TARGET";
    private static String HAS_MAGIC = "MAHOUTSUKAI_PLAYER_HAS_MAGIC";
    private static String PREV_YAW = "MAHOUTSUKAI_PLAYER_PREV_YAW";
    private static String PREV_PITCH = "MAHOUTSUKAI_PLAYER_PREV_PITCH";
    private static String PREV_EYE_X = "MAHOUTSUKAI_PLAYER_PREV_EYE_X";
    private static String PREV_EYE_Y = "MAHOUTSUKAI_PLAYER_PREV_EYE_Y";
    private static String PREV_EYE_Z = "MAHOUTSUKAI_PLAYER_PREV_EYE_Z";
    private static String LAST_RECIPE_CLOTH = "MAHOUTSUKAI_LAST_RECIPE_CLOTH";
    private static String LAST_RECIPE = "MAHOUTSUKAI_LAST_RECIPE";
    private static String INTERESTING_X = "MAHOUTSUKAI_FAMILIAR_INTERESTING_BLOCK_X";
    private static String INTERESTING_Y = "MAHOUTSUKAI_FAMILIAR_INTERESTING_BLOCK_Y";
    private static String INTERESTING_Z = "MAHOUTSUKAI_FAMILIAR_INTERESTING_BLOCK_Z";
    private static String CANCEL_TIME = "MAHOUTSUKAI_CANCEL_TIME";
    private static String IMMUNITY_DAMAGE_TYPE = "MAHOUTSUKAI_IMMUNITY_DAMAGE_TYPE";
    private static String VISIBLE = "MAHOUTSUKAI_SHOW_MAHOU";
    private static String FAE_SPAWN = "MAHOUTSUKAI_FAE_SPAWN";
    private static String GEAS = "MAHOUTSUKAI_GEAS";
    private static String PAGE = "MAHOUTSUKAI_PAGE";

    public static Tag writeNBT(IMahou instance) {
        ArrayList<String> order;
        UnorderedList lst;
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_(PLAYER_STORED_MANA, instance.getStoredMana());
        nbt.m_128405_(PLAYER_MAX_MANA, instance.getMaxMana());
        nbt.m_128347_(PLAYER_CHARGE_RATE, instance.getChargeRate());
        nbt.m_128405_(PLAYER_MANA_TO_USE_COUNTER, instance.getManaToUseCounter());
        nbt.m_128379_(PLAYER_FULL_MANA_FLAG, instance.isManaFull());
        if (instance.getImmunityDamageType() != null) {
            nbt.m_128359_(IMMUNITY_DAMAGE_TYPE, instance.getImmunityDamageType());
        }
        if (instance.getEnemy() != null) {
            nbt.m_128362_(PLAYER_ENEMY, instance.getEnemy());
        }
        if (instance.getPlayerSavedSpawn() != null) {
            nbt.m_128405_(PLAYER_SAVED_SPAWN_X, instance.getPlayerSavedSpawn().m_123341_());
            nbt.m_128405_(PLAYER_SAVED_SPAWN_Y, instance.getPlayerSavedSpawn().m_123342_());
            nbt.m_128405_(PLAYER_SAVED_SPAWN_Z, instance.getPlayerSavedSpawn().m_123343_());
        }
        if (instance.getPlayerMarbleSpawn() != null) {
            nbt.m_128405_(PLAYER_MARBLE_SPAWN_X, instance.getPlayerMarbleSpawn().m_123341_());
            nbt.m_128405_(PLAYER_MARBLE_SPAWN_Y, instance.getPlayerMarbleSpawn().m_123342_());
            nbt.m_128405_(PLAYER_MARBLE_SPAWN_Z, instance.getPlayerMarbleSpawn().m_123343_());
        }
        if (instance.getPlayerOldDimension() != null) {
            nbt.m_128359_(PLAYER_OLD_DIMENSION, instance.getPlayerOldDimension());
        }
        if (instance.getMemorizedEDMTE() != null) {
            nbt.m_128405_(MEMORIZED_EDMTE_X, instance.getMemorizedEDMTE().pos.m_123341_());
            nbt.m_128405_(MEMORIZED_EDMTE_Y, instance.getMemorizedEDMTE().pos.m_123342_());
            nbt.m_128405_(MEMORIZED_EDMTE_Z, instance.getMemorizedEDMTE().pos.m_123343_());
            if (instance.getMemorizedEDMTE().dim != null) {
                nbt.m_128359_(MEMORIZED_EDMTE_D, instance.getMemorizedEDMTE().dim.toString());
            }
        }
        if (instance.getLastArrowShot() != null) {
            nbt.m_128362_(PLAYER_LAST_ARROW, instance.getLastArrowShot());
        }
        if (instance.getMentalDisplacementPos() != null) {
            nbt.m_128405_(MENTAL_DISPLACEMENT_X, instance.getMentalDisplacementPos().m_123341_());
            nbt.m_128405_(MENTAL_DISPLACEMENT_Y, instance.getMentalDisplacementPos().m_123342_());
            nbt.m_128405_(MENTAL_DISPLACEMENT_Z, instance.getMentalDisplacementPos().m_123343_());
        }
        nbt.m_128405_(PROTECTIVE_DISPLACEMENT_USES, instance.getProtectiveDisplacement());
        nbt.m_128405_(DAMAGE_EXCHANGE_USES, instance.getDamageExchangeUses());
        nbt.m_128350_(DEATH_COLLECTION_USES_LEFT, instance.getDeathCollectionUsesLeft());
        nbt.m_128379_(IS_POSSESSING, instance.isPossessing());
        nbt.m_128379_(HAS_MAGIC, instance.hasMagic());
        nbt.m_128350_(PREV_PITCH, instance.getPlayerPrevPitch());
        nbt.m_128350_(PREV_YAW, instance.getPlayerPrevYaw());
        if (instance.getPlayerPrevEyePos() != null) {
            nbt.m_128350_(PREV_EYE_X, (float)instance.getPlayerPrevEyePos().f_82479_);
            nbt.m_128350_(PREV_EYE_Y, (float)instance.getPlayerPrevEyePos().f_82480_);
            nbt.m_128350_(PREV_EYE_Z, (float)instance.getPlayerPrevEyePos().f_82481_);
        }
        if (instance.getFamiliarInterestingBlock() != null) {
            nbt.m_128350_(INTERESTING_X, (float)instance.getFamiliarInterestingBlock().m_123341_());
            nbt.m_128350_(INTERESTING_Y, (float)instance.getFamiliarInterestingBlock().m_123342_());
            nbt.m_128350_(INTERESTING_Z, (float)instance.getFamiliarInterestingBlock().m_123343_());
        }
        if (instance.getDamageReplicationTarget() != null) {
            nbt.m_128362_(DAMAGE_REPLICATION_TARGET, instance.getDamageReplicationTarget());
        }
        if (instance.getLastRecipe() != null && (lst = instance.getLastRecipe()).size() == 3 && (order = lst.getOrder()) != null && order.size() == 3) {
            String s1 = (String)order.get(0);
            String s2 = (String)order.get(1);
            String s3 = (String)order.get(2);
            nbt.m_128359_(LAST_RECIPE + "1", s1);
            nbt.m_128359_(LAST_RECIPE + "2", s2);
            nbt.m_128359_(LAST_RECIPE + "3", s3);
        }
        nbt.m_128379_(LAST_RECIPE_CLOTH, instance.getLastRecipeCloth());
        nbt.m_128356_(CANCEL_TIME, instance.getCancelTime());
        nbt.m_128379_(VISIBLE, instance.getVisible());
        nbt.m_128379_(FAE_SPAWN, instance.getFaeSpawn());
        if (instance.getGeas() != null) {
            int i = 0;
            for (String g : instance.getGeas()) {
                nbt.m_128359_(GEAS + i, g);
                ++i;
            }
        }
        nbt.m_128405_(PAGE, instance.getGuidePage());
        return nbt;
    }

    public static void readNBT(IMahou instance, Tag nbtb) {
        CompoundTag nbt = (CompoundTag)nbtb;
        instance.clearBuffs();
        instance.setChargeRate(nbt.m_128459_(PLAYER_CHARGE_RATE));
        instance.setManaFull(nbt.m_128471_(PLAYER_FULL_MANA_FLAG));
        instance.setManaToUseCounter(nbt.m_128451_(PLAYER_MANA_TO_USE_COUNTER));
        instance.setMaxMana(nbt.m_128451_(PLAYER_MAX_MANA));
        if (nbt.m_128441_(IMMUNITY_DAMAGE_TYPE)) {
            instance.setImmunityDamageType(nbt.m_128461_(IMMUNITY_DAMAGE_TYPE));
        }
        instance.setStoredMana(nbt.m_128451_(PLAYER_STORED_MANA));
        if (nbt.m_128441_(PLAYER_SAVED_SPAWN_X) && nbt.m_128441_(PLAYER_SAVED_SPAWN_Y) && nbt.m_128441_(PLAYER_SAVED_SPAWN_Z)) {
            instance.setPlayerSavedSpawn(new BlockPos(nbt.m_128451_(PLAYER_SAVED_SPAWN_X), nbt.m_128451_(PLAYER_SAVED_SPAWN_Y), nbt.m_128451_(PLAYER_SAVED_SPAWN_Z)));
        }
        if (nbt.m_128441_(PLAYER_MARBLE_SPAWN_X) && nbt.m_128441_(PLAYER_MARBLE_SPAWN_Y) && nbt.m_128441_(PLAYER_MARBLE_SPAWN_Z)) {
            instance.setPlayerMarbleSpawn(new BlockPos(nbt.m_128451_(PLAYER_MARBLE_SPAWN_X), nbt.m_128451_(PLAYER_MARBLE_SPAWN_Y), nbt.m_128451_(PLAYER_MARBLE_SPAWN_Z)));
        }
        if (nbt.m_128441_(INTERESTING_X) && nbt.m_128441_(INTERESTING_Y) && nbt.m_128441_(INTERESTING_Z)) {
            instance.setFamiliarInterestingBlock(new BlockPos(nbt.m_128451_(INTERESTING_X), nbt.m_128451_(INTERESTING_Y), nbt.m_128451_(INTERESTING_Z)));
        }
        if (nbt.m_128441_(PLAYER_OLD_DIMENSION)) {
            instance.setPlayerOldDimension(nbt.m_128461_(PLAYER_OLD_DIMENSION));
        }
        if (nbt.m_128403_(PLAYER_ENEMY)) {
            instance.setEnemy(nbt.m_128342_(PLAYER_ENEMY));
        }
        if (nbt.m_128403_(PLAYER_LAST_ARROW)) {
            instance.setLastArrowShot(nbt.m_128342_(PLAYER_LAST_ARROW));
        }
        if (nbt.m_128441_(MEMORIZED_EDMTE_X) && nbt.m_128441_(MEMORIZED_EDMTE_Y) && nbt.m_128441_(MEMORIZED_EDMTE_Z)) {
            BlockDim blockDim = new BlockDim(new BlockPos(nbt.m_128451_(MEMORIZED_EDMTE_X), nbt.m_128451_(MEMORIZED_EDMTE_Y), nbt.m_128451_(MEMORIZED_EDMTE_Z)), nbt.m_128441_(MEMORIZED_EDMTE_D) ? new ResourceLocation(nbt.m_128461_(MEMORIZED_EDMTE_D)) : Level.f_46428_.m_135782_());
            instance.setMemorizedEDMTE(blockDim);
        }
        if (nbt.m_128441_(MENTAL_DISPLACEMENT_X) && nbt.m_128441_(MENTAL_DISPLACEMENT_Y) && nbt.m_128441_(MENTAL_DISPLACEMENT_Z)) {
            BlockPos pos = new BlockPos(nbt.m_128451_(MENTAL_DISPLACEMENT_X), nbt.m_128451_(MENTAL_DISPLACEMENT_Y), nbt.m_128451_(MENTAL_DISPLACEMENT_Z));
            instance.setMentalDisplacementPos(pos);
        }
        if (nbt.m_128441_(PREV_EYE_X) && nbt.m_128441_(PREV_EYE_Y) && nbt.m_128441_(PREV_EYE_Z)) {
            Vec3 vec = new Vec3((double)nbt.m_128457_(PREV_EYE_X), (double)nbt.m_128457_(PREV_EYE_Y), (double)nbt.m_128457_(PREV_EYE_Z));
            instance.setPlayerPrevEyePos(vec);
        }
        instance.setProtectiveDisplacement(nbt.m_128451_(PROTECTIVE_DISPLACEMENT_USES));
        instance.setDamageExchangeUses(nbt.m_128451_(DAMAGE_EXCHANGE_USES));
        instance.setDeathCollectionUsesLeft(nbt.m_128457_(DEATH_COLLECTION_USES_LEFT));
        instance.setPossessing(nbt.m_128471_(IS_POSSESSING));
        instance.setHasMagic(nbt.m_128471_(HAS_MAGIC));
        instance.setPlayerPrevPitch(nbt.m_128457_(PREV_PITCH));
        instance.setPlayerPrevYaw(nbt.m_128457_(PREV_YAW));
        if (nbt.m_128403_(DAMAGE_REPLICATION_TARGET)) {
            instance.setDamageReplicationTarget(nbt.m_128342_(DAMAGE_REPLICATION_TARGET));
        } else {
            instance.setDamageReplicationTarget(null);
        }
        instance.setLastRecipeCloth(nbt.m_128471_(LAST_RECIPE_CLOTH));
        if (nbt.m_128441_(LAST_RECIPE + "1") && nbt.m_128441_(LAST_RECIPE + "2") && nbt.m_128441_(LAST_RECIPE + "3")) {
            UnorderedList ul = MahoujinRecipeRegistrar.makeRecipe(nbt.m_128461_(LAST_RECIPE + "1"), nbt.m_128461_(LAST_RECIPE + "2"), nbt.m_128461_(LAST_RECIPE + "3"));
            instance.setLastRecipe(ul);
        }
        instance.setCancelTime(nbt.m_128454_(CANCEL_TIME));
        if (nbt.m_128441_(VISIBLE)) {
            instance.setVisible(nbt.m_128471_(VISIBLE));
        } else {
            instance.setVisible(true);
        }
        if (nbt.m_128441_(FAE_SPAWN)) {
            instance.setFaeSpawn(nbt.m_128471_(FAE_SPAWN));
        } else {
            instance.setFaeSpawn(true);
        }
        HashSet<String> hs = new HashSet<String>();
        int b = 0;
        while (nbt.m_128441_(GEAS + b)) {
            hs.add(nbt.m_128461_(GEAS + b));
            ++b;
        }
        instance.setGeas(hs);
        instance.setGuidePage(nbt.m_128451_(PAGE));
    }
}

