/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet;

import com.glodblock.github.glodium.network.packet.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.pedroksl.advanced_ae.client.gui.QuantumCrafterScreen;

public class PatternsUpdatePacket
implements IMessage<PatternsUpdatePacket> {
    private List<Boolean> invalidPatterns;
    private List<Boolean> enabledPatterns;

    public PatternsUpdatePacket() {
    }

    public PatternsUpdatePacket(List<Boolean> invalidPatterns, List<Boolean> enabledPatterns) {
        this.invalidPatterns = invalidPatterns;
        this.enabledPatterns = enabledPatterns;
    }

    public void fromBytes(FriendlyByteBuf stream) {
        int x;
        ArrayList<Boolean> invalidList = new ArrayList<Boolean>();
        ArrayList<Boolean> enabledList = new ArrayList<Boolean>();
        int size = stream.readInt();
        for (x = 0; x < size; ++x) {
            invalidList.add(stream.readBoolean());
        }
        size = stream.readInt();
        for (x = 0; x < size; ++x) {
            enabledList.add(stream.readBoolean());
        }
        this.invalidPatterns = invalidList;
        this.enabledPatterns = enabledList;
    }

    public void toBytes(FriendlyByteBuf data) {
        data.writeInt(this.invalidPatterns.size());
        for (Boolean entry : this.invalidPatterns) {
            data.writeBoolean(entry.booleanValue());
        }
        data.writeInt(this.enabledPatterns.size());
        for (Boolean entry : this.enabledPatterns) {
            data.writeBoolean(entry.booleanValue());
        }
    }

    public void onMessage(Player player) {
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof QuantumCrafterScreen) {
            QuantumCrafterScreen screen2 = (QuantumCrafterScreen)screen;
            screen2.updateInvalidButtons(this.invalidPatterns);
            screen2.updateEnabledButtons(this.enabledPatterns);
        }
    }

    public Class<PatternsUpdatePacket> getPacketClass() {
        return PatternsUpdatePacket.class;
    }

    public boolean isClient() {
        return true;
    }
}

