/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.network.packet;

import appeng.api.features.HotkeyAction;
import appeng.core.AELog;
import appeng.core.localization.PlayerMessages;
import com.glodblock.github.glodium.network.packet.IMessage;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.pedroksl.advanced_ae.client.Hotkeys;
import net.pedroksl.advanced_ae.common.definitions.AAEHotkeys;

public class AAEHotkeyPacket
implements IMessage<AAEHotkeyPacket> {
    private String hotkey;

    public AAEHotkeyPacket() {
    }

    public AAEHotkeyPacket(String hotkey) {
        this.hotkey = hotkey;
    }

    public AAEHotkeyPacket(Hotkeys.AAEHotkey hotkey) {
        this.hotkey = hotkey.name();
    }

    public void fromBytes(FriendlyByteBuf stream) {
        this.hotkey = stream.m_130277_();
    }

    public void toBytes(FriendlyByteBuf data) {
        data.m_130070_(this.hotkey);
    }

    public void onMessage(Player player) {
        List<HotkeyAction> actions = AAEHotkeys.REGISTRY.get(this.hotkey);
        if (actions == null) {
            player.m_213846_((Component)PlayerMessages.UnknownHotkey.text().m_6881_().m_7220_((Component)Component.m_237115_((String)("key.advanced_ae." + this.hotkey))));
            AELog.warn((String)"Player %s tried using unknown hotkey \"%s\"", (Object[])new Object[]{player, this.hotkey});
            return;
        }
        for (HotkeyAction action : actions) {
            if (action.run(player)) break;
        }
    }

    public Class<AAEHotkeyPacket> getPacketClass() {
        return AAEHotkeyPacket.class;
    }

    public boolean isClient() {
        return false;
    }
}

