/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.gui.quantumcomputer;

import appeng.api.client.AEKeyRendering;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.client.gui.Icon;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.world.level.ItemLike;

public class InfoBar {
    private final List<Widget> widgets = new ArrayList<Widget>();

    public void render(GuiGraphics guiGraphics, int x, int y) {
        int maxHeight = this.widgets.stream().mapToInt(Widget::getHeight).max().orElse(0);
        for (Widget widget : this.widgets) {
            widget.render(guiGraphics, x, Math.round((float)y + (float)maxHeight / 2.0f - (float)widget.getHeight() / 2.0f));
            x += widget.getWidth();
        }
    }

    void add(Icon icon, float scale) {
        this.widgets.add(new IconWidget(icon, scale));
    }

    void add(String text, int color, float scale) {
        this.widgets.add(new TextWidget((Component)Component.m_237113_((String)text), color, scale));
    }

    void add(Component text, int color, float scale) {
        this.widgets.add(new TextWidget(text, color, scale));
    }

    void add(AEKey what, float scale) {
        this.widgets.add(new StackWidget(what, scale));
    }

    void add(ItemLike what, float scale) {
        this.widgets.add(new StackWidget((AEKey)AEItemKey.of((ItemLike)what), scale));
    }

    void addSpace(int width) {
        this.widgets.add(new SpaceWidget(width));
    }

    static interface Widget {
        public int getWidth();

        public int getHeight();

        public void render(GuiGraphics var1, int var2, int var3);
    }

    private record IconWidget(Icon icon, float scale) implements Widget
    {
        @Override
        public int getWidth() {
            return Math.round(16.0f * this.scale);
        }

        @Override
        public int getHeight() {
            return Math.round(16.0f * this.scale);
        }

        @Override
        public void render(GuiGraphics guiGraphics, int x, int y) {
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)x, (float)y, 0.0f);
            poseStack.m_85841_(this.scale, this.scale, 1.0f);
            this.icon.getBlitter().dest(0, 0).blit(guiGraphics);
            poseStack.m_85849_();
        }
    }

    private static final class TextWidget
    implements Widget {
        private final Component text;
        private final int color;
        private final float scale;
        private final int width;
        private final int height;

        public TextWidget(Component text, int color, float scale) {
            this.text = text;
            this.color = color;
            this.scale = scale;
            Font font = Minecraft.m_91087_().f_91062_;
            this.width = Math.round((float)font.m_92852_((FormattedText)text) * scale);
            Objects.requireNonNull(font);
            this.height = Math.round(9.0f * scale);
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public void render(GuiGraphics guiGraphics, int x, int y) {
            PoseStack poseStack = guiGraphics.m_280168_();
            Font font = Minecraft.m_91087_().f_91062_;
            poseStack.m_85836_();
            poseStack.m_252880_((float)x, (float)y, 0.0f);
            poseStack.m_85841_(this.scale, this.scale, 1.0f);
            guiGraphics.m_280614_(font, this.text, 0, 0, this.color, false);
            poseStack.m_85849_();
        }
    }

    private record StackWidget(AEKey what, float scale) implements Widget
    {
        @Override
        public int getWidth() {
            return Math.round(16.0f * this.scale);
        }

        @Override
        public int getHeight() {
            return Math.round(16.0f * this.scale);
        }

        @Override
        public void render(GuiGraphics guiGraphics, int x, int y) {
            PoseStack poseStack = guiGraphics.m_280168_();
            poseStack.m_85836_();
            poseStack.m_252880_((float)x, (float)y, 0.0f);
            poseStack.m_85841_(this.scale, this.scale, 1.0f);
            AEKeyRendering.drawInGui((Minecraft)Minecraft.m_91087_(), (GuiGraphics)guiGraphics, (int)0, (int)0, (AEKey)this.what);
            poseStack.m_85849_();
        }
    }

    private static final class SpaceWidget
    implements Widget {
        private final int width;

        public SpaceWidget(int width) {
            this.width = width;
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return 0;
        }

        @Override
        public void render(GuiGraphics guiGraphics, int x, int y) {
        }
    }
}

