/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.items.armors;

import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.networking.IGrid;
import appeng.api.parts.SelectedPart;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.storage.ISubMenuHost;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.core.localization.Tooltips;
import appeng.menu.ISubMenu;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.menu.me.crafting.CraftAmountMenu;
import java.util.List;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.pedroksl.advanced_ae.client.renderer.QuantumArmorRenderer;
import net.pedroksl.advanced_ae.common.definitions.AAEItems;
import net.pedroksl.advanced_ae.common.definitions.AAEMaterials;
import net.pedroksl.advanced_ae.common.definitions.AAEText;
import net.pedroksl.advanced_ae.common.helpers.PickCraftMenuHost;
import net.pedroksl.advanced_ae.common.items.armors.QuantumArmorBase;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeCards;
import net.pedroksl.advanced_ae.common.items.upgrades.UpgradeType;
import net.pedroksl.advanced_ae.network.AAENetworkHandler;
import net.pedroksl.advanced_ae.network.packet.MenuSelectionPacket;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.bernie.geckolib.animatable.GeoItem;

public class QuantumChestplate
extends QuantumArmorBase
implements GeoItem,
ISubMenuHost {
    private static final double MAX_POWER_STORAGE = 3.0E8;

    public QuantumChestplate(Item.Properties properties) {
        super(AAEMaterials.QUANTUM_ALLOY, ArmorItem.Type.CHESTPLATE, properties, () -> 3.0E8);
        this.registerUpgrades(UpgradeType.FLIGHT, UpgradeType.HP_BUFFER, UpgradeType.LAVA_IMMUNITY, UpgradeType.REGENERATION, UpgradeType.STRENGTH, UpgradeType.ATTACK_SPEED, UpgradeType.CHARGING, UpgradeType.PICK_CRAFT);
    }

    @Override
    protected void appendExtraHoverText(ItemStack stack, @NotNull Level context, List<Component> lines, TooltipFlag advancedTooltips) {
        lines.add((Component)AAEText.QuantumArmorStableFootingTooltip.text().m_130948_(Tooltips.NUMBER_TEXT));
    }

    public void m_6883_(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (slotId == EquipmentSlot.CHEST.m_20749_()) {
                if (!this.getPassiveUpgrades(stack).isEmpty()) {
                    this.tickUpgrades(level, player, stack);
                }
                if (level.m_5776_()) {
                    this.toggleBoneVisibilities(stack, player);
                }
            } else {
                this.tickCreativeFlight(level, player, stack);
            }
        }
    }

    public void tickCreativeFlight(Level level, Player player, ItemStack stack) {
        if (this.getPassiveUpgrades(stack).contains((Object)UpgradeType.FLIGHT)) {
            UpgradeCards.creativeFlight(level, player, stack, false);
            if (player.m_150110_().f_35935_) {
                this.consumeEnergy(player, stack, UpgradeType.FLIGHT);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void toggleBoneVisibilities(ItemStack stack, Player player) {
        QuantumArmorBase item = (QuantumArmorBase)stack.m_41720_();
        HumanoidModel renderer = IClientItemExtensions.of((Item)item).getHumanoidArmorModel((LivingEntity)player, stack, EquipmentSlot.CHEST, null);
        if (renderer instanceof QuantumArmorRenderer) {
            QuantumArmorRenderer quantumRenderer = (QuantumArmorRenderer)renderer;
            boolean visible = item.hasUpgrade(stack, UpgradeType.STRENGTH);
            quantumRenderer.setBoneVisible("blade_left", visible);
            quantumRenderer.setBoneVisible("blade_right", visible);
        }
    }

    @Override
    public boolean openFromEquipmentSlot(Player player, int inventorySlot, ItemStack stack, boolean returningFromSubmenu) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.checkPreconditions(stack)) {
                player.getPersistentData().m_128405_("aae$menutype", QuantumArmorBase.MenuId.STANDARD.id);
                AAENetworkHandler.INSTANCE.sendTo(new MenuSelectionPacket("aae$menutype", QuantumArmorBase.MenuId.STANDARD.id), serverPlayer);
            }
        }
        return super.openFromEquipmentSlot(player, inventorySlot, stack, returningFromSubmenu);
    }

    public boolean attemptCraftingTarget(Player player, int inventorySlot, ItemStack stack) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.checkPreconditions(stack)) {
                UpgradeType upgrade;
                QuantumChestplate chestStack = (QuantumChestplate)stack.m_41720_();
                if (chestStack.hasUpgrade(stack, upgrade = UpgradeType.PICK_CRAFT)) {
                    if (chestStack.isUpgradeEnabled(stack, upgrade)) {
                        AEKey key = this.targetKey(player);
                        if (key != null) {
                            if (this.keyIsCraftable(player, stack, key)) {
                                player.getPersistentData().m_128405_("aae$menutype", QuantumArmorBase.MenuId.CRAFTING.id);
                                AAENetworkHandler.INSTANCE.sendTo(new MenuSelectionPacket("aae$menutype", QuantumArmorBase.MenuId.CRAFTING.id), serverPlayer);
                                CraftAmountMenu.open((ServerPlayer)serverPlayer, (MenuLocator)MenuLocators.forInventorySlot((int)inventorySlot), (AEKey)key, (int)1);
                            }
                        } else {
                            player.m_5661_((Component)AAEText.NoAvailableTarget.text(), true);
                        }
                    } else {
                        MutableComponent id = Component.m_237115_((String)upgrade.item().m_5456_().m_5524_());
                        player.m_5661_((Component)AAEText.UpgradeNotEnabledMessage.text(new Object[]{id}), true);
                    }
                } else {
                    MutableComponent id = Component.m_237115_((String)upgrade.item().m_5456_().m_5524_());
                    player.m_5661_((Component)AAEText.UpgradeNotInstalledMessage.text(new Object[]{id}), true);
                }
            }
        }
        return false;
    }

    @Override
    public ItemMenuHost getMenuHost(Player player, int inventorySlot, ItemStack stack, @Nullable BlockPos pos) {
        if (player.getPersistentData().m_128441_("aae$menutype") && player.getPersistentData().m_128451_("aae$menutype") == QuantumArmorBase.MenuId.STANDARD.id) {
            player.getPersistentData().m_128473_("aae$menutype");
            return super.getMenuHost(player, inventorySlot, stack, pos);
        }
        player.getPersistentData().m_128473_("aae$menutype");
        return new PickCraftMenuHost(player, inventorySlot, stack);
    }

    private AEKey targetKey(Player player) {
        BlockHitResult blockHitResult;
        HitResult hitResult = player.m_19907_(player.getBlockReach(), 0.0f, false);
        if (hitResult instanceof BlockHitResult && (blockHitResult = (BlockHitResult)hitResult).m_6662_() == HitResult.Type.BLOCK) {
            BlockEntity blockEntity;
            BlockPos blockPos = blockHitResult.m_82425_();
            BlockState blockState = player.m_9236_().m_8055_(blockPos);
            ItemStack itemStack = blockState.m_60734_().m_5456_().m_7968_();
            if (blockState.m_155947_() && (blockEntity = player.m_9236_().m_7702_(blockPos)) != null) {
                if (blockEntity instanceof CableBusBlockEntity) {
                    CableBusBlockEntity cable = (CableBusBlockEntity)blockEntity;
                    SelectedPart part = QuantumChestplate.getSelectedPart(cable, hitResult);
                    if (part != null && part.part != null) {
                        itemStack = new ItemStack((ItemLike)part.part.getPartItem().m_5456_(), 1);
                    }
                } else {
                    blockEntity.m_187476_(itemStack);
                }
            }
            return AEItemKey.of((ItemStack)itemStack.m_41720_().m_7968_());
        }
        return null;
    }

    private static SelectedPart getSelectedPart(CableBusBlockEntity cable, HitResult hitResult) {
        double z;
        double y;
        Vec3 loc = hitResult.m_82450_();
        double x = loc.f_82479_ - (double)((int)loc.f_82479_);
        if (x < 0.0) {
            x += 1.0;
        }
        if ((y = loc.f_82480_ - (double)((int)loc.f_82480_)) < 0.0) {
            y += 1.0;
        }
        if ((z = loc.f_82481_ - (double)((int)loc.f_82481_)) < 0.0) {
            z += 1.0;
        }
        Vec3 vec = new Vec3(x, y, z);
        return cable.selectPartLocal(vec);
    }

    public boolean keyIsCraftable(Player player, ItemStack stack, AEKey whatToCraft) {
        MutableObject errorHolder = new MutableObject();
        IGrid grid = this.getLinkedGrid(stack, player.m_9236_(), player);
        if (grid != null) {
            if (grid.getCraftingService().isCraftable(whatToCraft)) {
                return true;
            }
            player.m_5661_((Component)AAEText.ItemNotCraftable.text(), true);
        }
        return false;
    }

    public void returnToMainMenu(Player player, ISubMenu iSubMenu) {
    }

    public ItemStack getMainMenuIcon() {
        return AAEItems.QUANTUM_CHESTPLATE.stack();
    }
}

