/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.common.items.armors;

import appeng.api.config.AccessRestriction;
import appeng.api.config.Actionable;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.core.localization.Tooltips;
import java.util.List;
import java.util.function.DoubleSupplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.pedroksl.advanced_ae.common.helpers.PoweredItemCapabilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PoweredItem
extends ArmorItem
implements IAEItemPowerStorage {
    private static final double MIN_POWER = 1.0E-4;
    private static final String CURRENT_POWER_NBT_KEY = "internalCurrentPower";
    private static final String MAX_POWER_NBT_KEY = "internalMaxPower";
    private final DoubleSupplier powerCapacity;
    private PoweredItemCapabilities cap;

    public PoweredItem(ArmorMaterial material, ArmorItem.Type type, Item.Properties properties, DoubleSupplier powerCapacity) {
        super(material, type, properties);
        this.powerCapacity = powerCapacity;
    }

    public void addToMainCreativeTab(CreativeModeTab.ItemDisplayParameters parameters, CreativeModeTab.Output output) {
        output.m_246326_((ItemLike)this);
        ItemStack charged = new ItemStack((ItemLike)this, 1);
        this.injectAEPower(charged, this.getAEMaxPower(charged), Actionable.MODULATE);
        output.m_246342_(charged);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @NotNull Level context, List<Component> lines, TooltipFlag advancedTooltips) {
        double storedEnergy = this.getAECurrentPower(stack);
        double energyCapacity = this.getAEMaxPower(stack);
        lines.add(Tooltips.energyStorageComponent((double)storedEnergy, (double)energyCapacity));
    }

    public boolean m_142522_(ItemStack stack) {
        return this.getAECurrentPower(stack) / this.getAEMaxPower(stack) < (double)0.99f;
    }

    public int m_142158_(ItemStack stack) {
        double filled = this.getAECurrentPower(stack) / this.getAEMaxPower(stack);
        return Mth.m_14045_((int)((int)(filled * 13.0)), (int)0, (int)13);
    }

    public int m_142159_(ItemStack stack) {
        return Mth.m_14169_((float)0.33333334f, (float)1.0f, (float)1.0f);
    }

    public double injectAEPower(ItemStack stack, double amount, Actionable mode) {
        double maxStorage = this.getAEMaxPower(stack);
        double currentStorage = this.getAECurrentPower(stack);
        double required = maxStorage - currentStorage;
        double overflow = Math.max(0.0, Math.min(amount - required, amount));
        if (mode == Actionable.MODULATE) {
            double toAdd = Math.min(amount, required);
            this.setAECurrentPower(stack, currentStorage + toAdd);
        }
        return overflow;
    }

    public double extractAEPower(ItemStack stack, double amount, Actionable mode) {
        double currentStorage = this.getAECurrentPower(stack);
        double fulfillable = Math.min(amount, currentStorage);
        if (mode == Actionable.MODULATE) {
            this.setAECurrentPower(stack, currentStorage - fulfillable);
        }
        return fulfillable;
    }

    public double getAEMaxPower(ItemStack stack) {
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128425_(MAX_POWER_NBT_KEY, 6)) {
            return tag.m_128459_(MAX_POWER_NBT_KEY);
        }
        return this.powerCapacity.getAsDouble();
    }

    protected final void setAEMaxPower(ItemStack stack, double maxPower) {
        double defaultCapacity = this.powerCapacity.getAsDouble();
        if (Math.abs(maxPower - defaultCapacity) < 1.0E-4) {
            stack.m_41749_(MAX_POWER_NBT_KEY);
            maxPower = defaultCapacity;
        } else {
            stack.m_41784_().m_128347_(MAX_POWER_NBT_KEY, maxPower);
        }
        double currentPower = this.getAECurrentPower(stack);
        if (currentPower > maxPower) {
            this.setAECurrentPower(stack, maxPower);
        }
    }

    protected final void setAEMaxPowerMultiplier(ItemStack stack, int multiplier) {
        multiplier = Mth.m_14045_((int)multiplier, (int)1, (int)100);
        this.setAEMaxPower(stack, (double)multiplier * this.powerCapacity.getAsDouble());
    }

    protected final void resetAEMaxPower(ItemStack stack) {
        this.setAEMaxPower(stack, this.powerCapacity.getAsDouble());
    }

    public double getAECurrentPower(ItemStack is) {
        CompoundTag tag = is.m_41783_();
        if (tag != null) {
            return tag.m_128459_(CURRENT_POWER_NBT_KEY);
        }
        return 0.0;
    }

    protected final void setAECurrentPower(ItemStack stack, double power) {
        if (power < 1.0E-4) {
            stack.m_41749_(CURRENT_POWER_NBT_KEY);
        } else {
            stack.m_41784_().m_128347_(CURRENT_POWER_NBT_KEY, power);
        }
    }

    public AccessRestriction getPowerFlow(ItemStack is) {
        return AccessRestriction.WRITE;
    }

    public double getChargeRate(ItemStack itemStack) {
        return 20000.0;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new PoweredItemCapabilities(stack, this);
    }
}

