/*
 * Decompiled with CFR 0.152.
 */
package net.pedroksl.advanced_ae.client.gui.widgets;

import appeng.client.Point;
import appeng.client.gui.ICompositeWidget;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.pedroksl.advanced_ae.common.helpers.AAEColor;
import org.joml.Matrix4f;

public class AAESaturationValuePicker
implements ICompositeWidget {
    private Point position;
    private int width;
    private int height;
    private float hue;
    private float saturation;
    private float value;
    private final BiConsumer<Float, Float> saturationAndValueSetter;
    private boolean isDragging = false;

    public AAESaturationValuePicker() {
        this(0.0f, 0.0f, 0.0f, (s, v) -> {});
    }

    public AAESaturationValuePicker(float hue, float saturation, float value, BiConsumer<Float, Float> saturationAndValueSetter) {
        this.hue = hue;
        this.saturation = saturation;
        this.value = value;
        this.saturationAndValueSetter = saturationAndValueSetter;
    }

    public void drawBackgroundLayer(GuiGraphics guiGraphics, Rect2i bounds, Point mouse) {
        int minX = bounds.m_110085_() + this.position.getX();
        int minY = bounds.m_110086_() + this.position.getY();
        int w = this.width;
        int h = this.height;
        guiGraphics.m_280509_(minX - 1, minY - 1, minX + w + 1, minY + h + 1, AAEColor.DARK_GRAY_BLUE.argb());
        this.renderGradient(guiGraphics, minX, minY, w, h, AAEColor.ofHsv(this.hue, 0.0f, 1.0f).argb(), AAEColor.ofHsv(this.hue, 1.0f, 1.0f).argb(), AAEColor.ofHsv(this.hue, 0.0f, 0.0f).argb(), AAEColor.ofHsv(this.hue, 1.0f, 0.0f).argb());
        int hsvX = minX + (int)(this.saturation * (float)(this.width - 1));
        int hsvY = minY + (int)((1.0f - this.value) * (float)(this.height - 1));
        int color = AAEColor.WHITE.argb();
        guiGraphics.m_280656_(hsvX - 1, hsvX + 1, hsvY - 1, color);
        guiGraphics.m_280656_(hsvX - 1, hsvX + 1, hsvY - 1, color);
        guiGraphics.m_280656_(hsvX - 1, hsvX + 1, hsvY + 1, color);
        guiGraphics.m_280315_(hsvX - 1, hsvY - 1, hsvY + 1, color);
        guiGraphics.m_280315_(hsvX + 1, hsvY - 1, hsvY + 1, color);
    }

    private void renderGradient(GuiGraphics guiGraphics, int x, int y, int width, int height, int tlColor, int trColor, int blColor, int brColor) {
        RenderType type = RenderType.m_285907_();
        VertexConsumer buffer = guiGraphics.m_280091_().m_6299_(type);
        Matrix4f matrix = guiGraphics.m_280168_().m_85850_().m_252922_();
        buffer.m_252986_(matrix, (float)(x + width), (float)y, 0.0f).m_193479_(trColor);
        buffer.m_252986_(matrix, (float)x, (float)y, 0.0f).m_193479_(tlColor);
        buffer.m_252986_(matrix, (float)x, (float)(y + height), 0.0f).m_193479_(blColor);
        buffer.m_252986_(matrix, (float)(x + width), (float)(y + height), 0.0f).m_193479_(brColor);
    }

    public boolean onMouseDown(Point mousePos, int button) {
        if (button != 0) {
            return false;
        }
        this.isDragging = true;
        this.playDownSound();
        this.setValueFromMouse(mousePos.getX(), mousePos.getY());
        return true;
    }

    private void playDownSound() {
        SoundManager handler = Minecraft.m_91087_().m_91106_();
        handler.m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
    }

    public boolean onMouseUp(Point mousePos, int button) {
        this.isDragging = false;
        return false;
    }

    public boolean wantsAllMouseUpEvents() {
        return true;
    }

    public boolean onMouseDrag(Point mousePos, int button) {
        if (this.isDragging) {
            this.setValueFromMouse(mousePos.getX(), mousePos.getY());
            return true;
        }
        return false;
    }

    private void setValueFromMouse(double mouseX, double mouseY) {
        double x = (mouseX - (double)this.position.getX()) / (double)this.width;
        double y = (mouseY - (double)this.position.getY()) / (double)this.height;
        double newSaturation = Math.min(Math.max(x, 0.0), 1.0);
        double newValue = Math.min(Math.max(1.0 - y, 0.0), 1.0);
        this.applyValue((float)newSaturation, (float)newValue);
    }

    protected void applyValue(float newSaturation, float newValue) {
        if (!Mth.m_14033_((float)this.saturation, (float)newSaturation) || !Mth.m_14033_((float)this.value, (float)newValue)) {
            this.saturation = newSaturation;
            this.value = newValue;
            this.saturationAndValueSetter.accept(Float.valueOf(this.saturation), Float.valueOf(this.value));
        }
    }

    public void setHue(float hue) {
        this.hue = hue;
    }

    public void setValues(float saturation, float value) {
        this.saturation = saturation;
        this.value = value;
    }

    public void setPosition(Point position) {
        this.position = position;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public Rect2i getBounds() {
        return new Rect2i(this.position.getX(), this.position.getY(), this.width, this.height);
    }
}

