/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client.jei;

import com.google.common.collect.ImmutableList;
import commoble.morered.MoreRed;
import commoble.morered.client.jei.SolderingCategory;
import commoble.morered.soldering.SolderingRecipe;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

@JeiPlugin
public class JEIProxy
implements IModPlugin {
    public static final ResourceLocation ID = new ResourceLocation("morered", "morered");
    @Nullable
    private SolderingCategory solderingCategory;

    public ResourceLocation getPluginUid() {
        return ID;
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        this.solderingCategory = new SolderingCategory(registration.getJeiHelpers().getGuiHelper());
        registration.addRecipeCategories(new IRecipeCategory[]{this.solderingCategory});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (this.solderingCategory == null) {
            throw new NullPointerException("More Red's Soldering JEI category failed to register! Notify the More Red author for assistance https://github.com/Commoble/morered/issues");
        }
        registration.addRecipes(SolderingCategory.TYPE, JEIProxy.getSolderingRecipes());
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)MoreRed.get().solderingTableBlock.get()), new RecipeType[]{SolderingCategory.TYPE});
    }

    public static List<Recipe<CraftingContainer>> getSolderingRecipes() {
        ClientLevel clientLevel = Minecraft.m_91087_().f_91073_;
        if (clientLevel != null) {
            RecipeManager manager = clientLevel.m_7465_();
            return SolderingRecipe.getAllSolderingRecipes(manager, clientLevel.m_9598_());
        }
        return ImmutableList.of();
    }
}

