/*
 * Decompiled with CFR 0.152.
 */
package commoble.morered.client;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import commoble.morered.client.EdgeRotation;
import commoble.morered.client.FaceRotation;
import commoble.morered.wires.AbstractWireBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.BlockModelRotation;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IDynamicBakedModel;
import net.minecraftforge.client.model.data.ModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IGeometryBakingContext;
import net.minecraftforge.client.model.geometry.IGeometryLoader;
import net.minecraftforge.client.model.geometry.IUnbakedGeometry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WirePartModelLoader
implements IGeometryLoader<WirePartGeometry> {
    public static final WirePartModelLoader INSTANCE = new WirePartModelLoader();

    public WirePartGeometry read(JsonObject modelJson, JsonDeserializationContext context) {
        BlockModel lineModel = (BlockModel)context.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelJson, (String)"line"), BlockModel.class);
        BlockModel edgeModel = (BlockModel)context.deserialize((JsonElement)GsonHelper.m_13930_((JsonObject)modelJson, (String)"edge"), BlockModel.class);
        return new WirePartGeometry(lineModel, edgeModel);
    }

    public static class WirePartGeometry
    implements IUnbakedGeometry<WirePartGeometry> {
        private final BlockModel lineModel;
        private final BlockModel edgeModel;

        public WirePartGeometry(BlockModel lineModel, BlockModel edgeModel) {
            this.lineModel = lineModel;
            this.edgeModel = edgeModel;
        }

        public BakedModel bake(IGeometryBakingContext context, ModelBaker bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
            BakedModel[] lineModels = new BakedModel[24];
            BakedModel[] edgeModels = new BakedModel[12];
            boolean useBlockLight = context.useBlockLight();
            for (int side = 0; side < 6; ++side) {
                for (int subSide = 0; subSide < 4; ++subSide) {
                    int index = side * 4 + subSide;
                    FaceRotation transform = FaceRotation.getFaceRotation(side, subSide);
                    lineModels[index] = this.lineModel.m_111449_(bakery, this.lineModel, spriteGetter, (ModelState)transform, modelLocation, useBlockLight);
                }
            }
            for (int edge = 0; edge < 12; ++edge) {
                BlockModelRotation transform = EdgeRotation.EDGE_ROTATIONS[edge];
                edgeModels[edge] = this.edgeModel.m_111449_(bakery, this.edgeModel, spriteGetter, (ModelState)transform, modelLocation, useBlockLight);
            }
            return new WirePartModel(context.useAmbientOcclusion(), context.isGui3d(), useBlockLight, spriteGetter.apply(this.lineModel.m_111480_("particle")), lineModels, edgeModels);
        }

        public void resolveParents(Function<ResourceLocation, UnbakedModel> modelGetter, IGeometryBakingContext context) {
            this.lineModel.m_5500_(modelGetter);
            this.edgeModel.m_5500_(modelGetter);
        }
    }

    @Deprecated
    public static class MultipartWireModel
    extends BakedModelWrapper<BakedModel> {
        public MultipartWireModel(BakedModel originalModel) {
            super(originalModel);
        }

        @NotNull
        public ModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull ModelData modelData) {
            Block block = state.m_60734_();
            if (block instanceof AbstractWireBlock) {
                AbstractWireBlock wireBlock = (AbstractWireBlock)block;
                return ModelData.builder().with(WireModelData.PROPERTY, (Object)wireBlock.getExpandedShapeIndex(state, (BlockGetter)level, pos)).build();
            }
            return modelData;
        }
    }

    public static final class WireModelData {
        public static final ModelProperty<Long> PROPERTY = new ModelProperty();

        private WireModelData() {
        }

        public static boolean test(long flags, int bitIndex) {
            return (1L << bitIndex & flags) != 0L;
        }
    }

    public static class WirePartModel
    implements IDynamicBakedModel {
        private static final List<BakedQuad> NO_QUADS = ImmutableList.of();
        private final boolean isAmbientOcclusion;
        private final boolean isGui3d;
        private final boolean isSideLit;
        private final TextureAtlasSprite particle;
        private final BakedModel[] lineModels;
        private final BakedModel[] edgeModels;

        public WirePartModel(boolean isAmbientOcclusion, boolean isGui3d, boolean isSideLit, TextureAtlasSprite particle, BakedModel[] lineModels, BakedModel[] edgeModels) {
            this.isAmbientOcclusion = isAmbientOcclusion;
            this.isGui3d = isGui3d;
            this.isSideLit = isSideLit;
            this.particle = particle;
            this.lineModels = lineModels;
            this.edgeModels = edgeModels;
        }

        public boolean m_7541_() {
            return this.isAmbientOcclusion;
        }

        public boolean m_7539_() {
            return this.isGui3d;
        }

        public boolean m_7547_() {
            return this.isSideLit;
        }

        public boolean m_7521_() {
            return false;
        }

        public TextureAtlasSprite m_6160_() {
            return this.particle;
        }

        public ItemOverrides m_7343_() {
            return ItemOverrides.f_111734_;
        }

        public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData extraData, @Nullable RenderType renderType) {
            int i;
            Long wireData = (Long)extraData.get(WireModelData.PROPERTY);
            if (wireData == null) {
                return NO_QUADS;
            }
            long wireFlags = wireData;
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            int lineStart = 6;
            int lines = 24;
            int edgeStart = lineStart + lines;
            int edges = 12;
            for (i = 0; i < lines; ++i) {
                if (!WireModelData.test(wireFlags, i + lineStart)) continue;
                quads.addAll(this.lineModels[i].getQuads(state, side, rand, extraData, renderType));
            }
            for (i = 0; i < edges; ++i) {
                if (!WireModelData.test(wireFlags, i + edgeStart)) continue;
                quads.addAll(this.edgeModels[i].getQuads(state, side, rand, extraData, renderType));
            }
            return quads;
        }

        public ModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, ModelData modelData) {
            Block block = state.m_60734_();
            if (block instanceof AbstractWireBlock) {
                AbstractWireBlock wireBlock = (AbstractWireBlock)block;
                return ModelData.builder().with(WireModelData.PROPERTY, (Object)wireBlock.getExpandedShapeIndex(state, (BlockGetter)level, pos)).build();
            }
            return modelData;
        }
    }
}

