/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.util;

import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import cy.jdkdigital.productivelib.util.ColorUtil;
import cy.jdkdigital.productivetrees.ProductiveTrees;
import cy.jdkdigital.productivetrees.common.block.ProductiveLeavesBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveLogBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveSaplingBlock;
import cy.jdkdigital.productivetrees.common.block.ProductiveWoodBlock;
import cy.jdkdigital.productivetrees.common.block.entity.StripperBlockEntity;
import cy.jdkdigital.productivetrees.recipe.SawmillRecipe;
import cy.jdkdigital.productivetrees.registry.TreeFinder;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.registry.TreeRegistrator;
import cy.jdkdigital.productivetrees.registry.WoodObject;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class TreeUtil {
    public static final Codec<Supplier<ItemStack>> ITEM_STACK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("item").forGetter(stack -> ForgeRegistries.ITEMS.getKey((Object)((ItemStack)stack.get()).m_41720_())), (App)Codec.INT.fieldOf("count").orElse((Object)1).forGetter(stack -> ((ItemStack)stack.get()).m_41613_()), (App)CompoundTag.f_128325_.optionalFieldOf("nbt").forGetter(stack -> Optional.ofNullable(((ItemStack)stack.get()).m_41783_()))).apply((Applicative)instance, (item, count, tag) -> () -> {
        ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(item), count.intValue());
        tag.ifPresent(arg_0 -> ((ItemStack)stack).m_41751_(arg_0));
        return stack;
    }));
    public static final Path TREE_PATH = TreeUtil.createCustomPath("trees");
    public static final Path INTERNAL_TREE_PATH = TreeUtil.createModPath("/data/productivetrees/trees");
    public static final UUID STRIPPER_UUID = UUID.nameUUIDFromBytes("pt_stripper".getBytes(StandardCharsets.UTF_8));
    static Map<ItemStack, SawmillRecipe> sawmillRecipeCache = new HashMap<ItemStack, SawmillRecipe>();

    private static Path createCustomPath(String pathName) {
        Path customPath = Paths.get(FMLPaths.CONFIGDIR.get().toAbsolutePath().toString(), "productivetrees", pathName);
        TreeUtil.createDirectory(customPath, pathName);
        return customPath;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Path createModPath(String pathName) {
        List<Path> roots = List.of(ModList.get().getModFileById("productivetrees").getFile().getFilePath());
        for (Path modRoot : roots) {
            if (Files.isRegularFile(modRoot, new LinkOption[0])) {
                try (FileSystem fileSystem = FileSystems.newFileSystem(modRoot);){
                    Path path2 = fileSystem.getPath(pathName, new String[0]);
                    if (!Files.exists(path2, new LinkOption[0])) continue;
                    Path path = path2;
                    return path;
                }
                catch (IOException e) {
                    ProductiveTrees.LOGGER.error("Could not load source {}!!", (Object)modRoot);
                    e.printStackTrace();
                }
                continue;
            }
            if (!Files.isDirectory(modRoot, new LinkOption[0])) continue;
            return modRoot;
        }
        return null;
    }

    private static void createDirectory(Path path, String dirName) {
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            ProductiveTrees.LOGGER.error("failed to create \"" + dirName + "\" directory");
        }
    }

    public static int getLeafColor(Block leaf) {
        return TreeUtil.getLeafColor(leaf, null, null);
    }

    public static int getLeafColor(Block leaf, BlockAndTintGetter lightReader, BlockPos pos) {
        if (leaf != null) {
            if (leaf instanceof ProductiveLeavesBlock) {
                ProductiveLeavesBlock leafBlock = (ProductiveLeavesBlock)leaf;
                return ColorUtil.getCacheColor((String)leafBlock.getTree().getLeafColor());
            }
            if (leaf.equals(Blocks.f_50051_)) {
                return FoliageColor.m_46106_();
            }
            if (leaf.equals(Blocks.f_50052_)) {
                return FoliageColor.m_46112_();
            }
        }
        if (lightReader != null && pos != null) {
            return BiomeColors.m_108804_((BlockAndTintGetter)lightReader, (BlockPos)pos);
        }
        return FoliageColor.m_46113_();
    }

    public static ItemStack getLeafFromSapling(ItemStack saplingStack) {
        ProductiveSaplingBlock saplingBlock;
        TreeObject tree;
        BlockItem blockItem;
        Item item = saplingStack.m_41720_();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof ProductiveSaplingBlock && (tree = TreeUtil.getTree((Block)(saplingBlock = (ProductiveSaplingBlock)item))) != null) {
            return new ItemStack((ItemLike)TreeUtil.getBlock(tree.getId(), "_leaves"));
        }
        ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)saplingStack.m_41720_());
        if (resourceLocation != null) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation.m_247266_(p -> p.replace("_sapling", "_propagule").replace("_sapling", "_leaves")));
            if (block.equals(Blocks.f_50016_)) {
                block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation.m_247266_(p -> p + "_leaves"));
            }
            if (block != null) {
                return new ItemStack((ItemLike)block);
            }
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getSaplingFromLeaf(ItemStack leafStack) {
        ProductiveLeavesBlock leavesBlock;
        TreeObject tree;
        BlockItem blockItem;
        Item item = leafStack.m_41720_();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).m_40614_()) instanceof ProductiveLeavesBlock && (tree = TreeUtil.getTree((Block)(leavesBlock = (ProductiveLeavesBlock)item))) != null) {
            return new ItemStack((ItemLike)TreeUtil.getBlock(tree.getId(), "_sapling"));
        }
        ResourceLocation resourceLocation = ForgeRegistries.ITEMS.getKey((Object)leafStack.m_41720_());
        if (resourceLocation != null) {
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation.m_247266_(p -> p.replace("_leaves", "_sapling")));
            if (block.equals(Blocks.f_50016_)) {
                block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation.m_247266_(p -> p.replace("_leaves", "_propagule")));
            }
            if (block.equals(Blocks.f_50016_)) {
                block = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation.m_247266_(p -> p.replace("_leaves", "")));
            }
            if (block != null) {
                return new ItemStack((ItemLike)block);
            }
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getStrippedItem(StripperBlockEntity blockEntity, ServerLevel level, ItemStack stack) {
        Item item;
        ItemStack stripped = TreeUtil.getStrippedItem(stack);
        if (stripped.m_41619_() && (item = stack.m_41720_()) instanceof BlockItem) {
            BlockPos pos;
            BlockHitResult blockHit;
            BlockItem blockItem = (BlockItem)item;
            BlockState initialState = blockItem.m_40614_().m_49966_();
            BlockState stripState = AxeItem.getAxeStrippingState((BlockState)initialState);
            FakePlayer fakePlayer = FakePlayerFactory.get((ServerLevel)level, (GameProfile)new GameProfile(STRIPPER_UUID, "stripper"));
            UseOnContext context = new UseOnContext((Player)fakePlayer, InteractionHand.MAIN_HAND, blockHit = new BlockHitResult(new Vec3((double)(pos = blockEntity.m_58899_()).m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), Direction.DOWN, pos, false));
            stripState = ForgeEventFactory.onToolUse((BlockState)initialState, (UseOnContext)context, (ToolAction)ToolActions.AXE_STRIP, (boolean)true);
            return !stripState.equals(initialState) ? new ItemStack((ItemLike)initialState.m_60734_()) : ItemStack.f_41583_;
        }
        return stripped;
    }

    public static ItemStack getStrippedItem(ItemStack stack) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            ProductiveWoodBlock pWood;
            ProductiveLogBlock pLog;
            Object tree;
            BlockItem blockItem = (BlockItem)item;
            BlockState initialState = blockItem.m_40614_().m_49966_();
            BlockState stripState = AxeItem.getAxeStrippingState((BlockState)initialState);
            if (stripState != null) {
                return new ItemStack((ItemLike)stripState.m_60734_());
            }
            Block block = initialState.m_60734_();
            if (block instanceof ProductiveLogBlock && (tree = TreeUtil.getTree((Block)(pLog = (ProductiveLogBlock)block))) != null) {
                return new ItemStack((ItemLike)TreeUtil.getBlock(((WoodObject)tree).getId(), "_stripped_log"));
            }
            tree = initialState.m_60734_();
            if (tree instanceof ProductiveWoodBlock && (tree = TreeUtil.getTree((Block)(pWood = (ProductiveWoodBlock)((Object)tree)))) != null) {
                return new ItemStack((ItemLike)TreeUtil.getBlock(((WoodObject)tree).getId(), "_stripped_wood"));
            }
        }
        return ItemStack.f_41583_;
    }

    public static SawmillRecipe getSawmillRecipe(Level level, ItemStack stack) {
        if (!stack.m_41619_()) {
            ItemStack cacheItem = stack.m_41777_();
            cacheItem.m_41764_(1);
            if (sawmillRecipeCache.containsKey(cacheItem)) {
                return sawmillRecipeCache.get(cacheItem);
            }
            List recipes = level.m_7465_().m_44013_((RecipeType)TreeRegistrator.SAW_MILLLING_TYPE.get());
            for (SawmillRecipe recipe : recipes) {
                if (!recipe.log.test(stack)) continue;
                sawmillRecipeCache.put(cacheItem, recipe);
                return recipe;
            }
        }
        return null;
    }

    public static ItemStack getPollen(Block block) {
        ItemStack pollenStack = new ItemStack((ItemLike)TreeRegistrator.POLLEN.get());
        pollenStack.m_41784_().m_128359_("Block", ForgeRegistries.BLOCKS.getKey((Object)block).toString());
        return pollenStack;
    }

    public static boolean isSpecialTree(ResourceLocation id) {
        return id.m_135815_().equals("purple_spiral") || id.m_135815_().equals("cave_dweller") || id.m_135815_().equals("black_ember") || id.m_135815_().equals("brown_amber") || id.m_135815_().equals("firecracker") || id.m_135815_().equals("flickering_sun") || id.m_135815_().equals("foggy_blast") || id.m_135815_().equals("night_fuchsia") || id.m_135815_().equals("time_traveller") || id.m_135815_().equals("rippling_willow") || id.m_135815_().equals("soul_tree") || id.m_135815_().equals("sparkle_cherry") || id.m_135815_().equals("slimy_delight") || id.m_135815_().equals("thunder_bolt") || id.m_135815_().equals("blue_yonder") || id.m_135815_().equals("water_wonder");
    }

    public static boolean isTranslucentTree(String name) {
        return name.equals("brown_amber") || name.equals("slimy_delight") || name.equals("foggy_blast") || name.equals("soul_tree") || name.equals("water_wonder");
    }

    public static Block getBlock(ResourceLocation tree, String name) {
        return (Block)ForgeRegistries.BLOCKS.getValue(tree.m_247266_(p -> p + name));
    }

    public static TreeObject getTree(Block block) {
        return TreeFinder.trees.get(ForgeRegistries.BLOCKS.getKey((Object)block).m_247266_(p -> p.replace("_log", "").replace("_wood", "").replace("_sapling", "").replace("_leaves", "")));
    }
}

