/*
 * Decompiled with CFR 0.152.
 */
package cy.jdkdigital.productivetrees.datagen.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import cy.jdkdigital.productivelib.util.RecipeUtil;
import cy.jdkdigital.productivetrees.ProductiveTrees;
import cy.jdkdigital.productivetrees.registry.TreeObject;
import cy.jdkdigital.productivetrees.util.TreeUtil;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public final class ThermalExtractorRecipeBuilder
implements RecipeBuilder {
    private final Block log;
    private final Block leaves;
    private final FluidStack fluid;
    public final Advancement.Builder advancement = Advancement.Builder.m_285878_();

    public ThermalExtractorRecipeBuilder(Block log, Block leaves, FluidStack fluid) {
        this.log = log;
        this.leaves = leaves;
        this.fluid = fluid;
    }

    public static ThermalExtractorRecipeBuilder direct(Block log, Block leaves, FluidStack fluid) {
        return new ThermalExtractorRecipeBuilder(log, leaves, fluid);
    }

    public RecipeBuilder m_126132_(String name, CriterionTriggerInstance criterion) {
        this.advancement.m_138386_(name, criterion);
        return this;
    }

    public RecipeBuilder m_126145_(@Nullable String p_176495_) {
        return null;
    }

    public Item m_142372_() {
        return this.log.m_5456_();
    }

    public void m_126140_(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.log, this.leaves, this.fluid, this.advancement));
    }

    record Result(ResourceLocation id, Block log, Block leaves, FluidStack fluid, Advancement.Builder advancement) implements FinishedRecipe
    {
        public void m_7917_(JsonObject json) {
            TreeObject tree = TreeUtil.getTree(this.log);
            json.add("trunk", (JsonElement)BlockState.f_61039_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.log.m_49966_()).getOrThrow(false, arg_0 -> ((Logger)ProductiveTrees.LOGGER).error(arg_0)));
            JsonObject leafJson = ((JsonElement)BlockState.f_61039_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)this.leaves.m_49966_()).getOrThrow(false, arg_0 -> ((Logger)ProductiveTrees.LOGGER).error(arg_0))).getAsJsonObject();
            JsonObject properties = leafJson.get("Properties").getAsJsonObject();
            properties.remove("distance");
            properties.remove("waterlogged");
            leafJson.add("Properties", (JsonElement)properties);
            if (tree.hasFruit()) {
                Block fruit = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("productivetrees", tree.getId().m_135815_() + "_fruit"));
                JsonObject fruitJson = ((JsonElement)BlockState.f_61039_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)fruit.m_49966_()).getOrThrow(false, arg_0 -> ((Logger)ProductiveTrees.LOGGER).error(arg_0))).getAsJsonObject();
                JsonObject fruitProperties = fruitJson.get("Properties").getAsJsonObject();
                fruitProperties.remove("distance");
                fruitProperties.remove("waterlogged");
                fruitProperties.remove("age");
                fruitJson.add("Properties", (JsonElement)fruitProperties);
                JsonArray leaves = new JsonArray();
                leaves.add((JsonElement)leafJson);
                leaves.add((JsonElement)fruitJson);
                json.add("leaves", (JsonElement)leaves);
            } else {
                json.add("leaves", (JsonElement)leafJson);
            }
            json.addProperty("min_height", (Number)4);
            json.addProperty("max_height", (Number)20);
            json.addProperty("min_leaves", (Number)10);
            json.addProperty("max_leaves", (Number)10);
            json.add("result", (JsonElement)RecipeUtil.fluidToJson((FluidStack)this.fluid));
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return (RecipeSerializer)ForgeRegistries.RECIPE_SERIALIZERS.getValue(new ResourceLocation("thermal:tree_extractor"));
        }

        @Nullable
        public JsonObject m_5860_() {
            return this.advancement.m_138400_();
        }

        @Nullable
        public ResourceLocation m_6448_() {
            return this.id.m_246208_("recipes/" + RecipeCategory.MISC.m_247710_() + "/");
        }
    }
}

