/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.network;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.PacketCustom;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.utils.MathUtils;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePortal;
import com.brandon3055.draconicevolution.client.CustomBossInfoHandler;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.render.effect.ExplosionFX;
import com.brandon3055.draconicevolution.client.render.hud.ShieldHudElement;
import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.control.IPhase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseManager;
import com.brandon3055.draconicevolution.init.ClientInit;
import com.brandon3055.draconicevolution.items.equipment.damage.DefaultStaffDmgMod;
import com.brandon3055.draconicevolution.network.CrystalUpdateBatcher;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;

public class ClientPacketHandler
implements ICustomPacketHandler.IClientPacketHandler {
    public void handlePacket(PacketCustom packet, Minecraft mc, ClientPacketListener handler) {
        switch (packet.getType()) {
            case 1: {
                CrystalUpdateBatcher.handleBatchedData((MCDataInput)packet);
                break;
            }
            case 3: {
                ClientPacketHandler.handleExplosionEffect(mc, packet.readPos(), packet.readVarInt(), packet.readBoolean());
                break;
            }
            case 4: {
                ClientPacketHandler.handleImpactEffect(mc, packet.readPos(), packet.readByte());
                break;
            }
            case 5: {
                ClientPacketHandler.handleUndyingActivation(mc, packet.readVarInt(), (Item)packet.readRegistryId());
                break;
            }
            case 6: {
                ClientPacketHandler.handleBlinkEffect(mc, packet.readVarInt(), packet.readFloat());
                break;
            }
            case 7: {
                ClientPacketHandler.handleStaffEffect(mc, (MCDataInput)packet);
                break;
            }
            case 8: {
                ClientPacketHandler.handleGuardianBeam(mc, (MCDataInput)packet);
                break;
            }
            case 9: {
                ClientPacketHandler.handleGuardianPacket(mc, (MCDataInput)packet);
                break;
            }
            case 10: {
                CustomBossInfoHandler.handlePacket((MCDataInput)packet);
                break;
            }
            case 11: {
                this.handleDislocatorTeleported(mc);
                break;
            }
            case 12: {
                this.handleChunkRelight(mc, packet.readInt(), packet.readInt());
            }
        }
    }

    public static void handleExplosionEffect(Minecraft mc, BlockPos pos, int radius, boolean reload) {
        if (reload) {
            mc.f_91060_.m_109818_();
        }
        if (radius == 0) {
            return;
        }
        ExplosionFX explosionFX = new ExplosionFX((ClientLevel)BrandonsCore.proxy.getClientWorld(), Vector3.fromBlockPosCenter((BlockPos)pos), radius);
        mc.f_91061_.m_107344_((Particle)explosionFX);
    }

    public static void handleImpactEffect(Minecraft mc, BlockPos pos, int type) {
        if (mc.f_91073_ == null) {
            return;
        }
        if (type == 0) {
            int size = 4;
            double speed = 1.0;
            double x = (double)pos.m_123341_() + 0.5;
            double y = (double)pos.m_123342_() + 0.5;
            double z = (double)pos.m_123343_() + 0.5;
            for (int i = -size; i <= size; ++i) {
                for (int j = -size; j <= size; ++j) {
                    for (int k = -size; k <= size; ++k) {
                        double d3 = (double)j + (mc.f_91073_.f_46441_.m_188500_() - mc.f_91073_.f_46441_.m_188500_()) * 0.5;
                        double d4 = (double)i + (mc.f_91073_.f_46441_.m_188500_() - mc.f_91073_.f_46441_.m_188500_()) * 0.5;
                        double d5 = (double)k + (mc.f_91073_.f_46441_.m_188500_() - mc.f_91073_.f_46441_.m_188500_()) * 0.5;
                        double d6 = Math.sqrt(d3 * d3 + d4 * d4 + d5 * d5) / speed + mc.f_91073_.f_46441_.m_188583_() * 6.0;
                        ClientPacketHandler.createParticle(mc, x, y, z, d3 / d6, d4 / d6, d5 / d6);
                        if (i == -size || i == size || j == -size || j == size) continue;
                        k += size * 2 - 1;
                    }
                }
            }
            mc.f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123812_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    private static void createParticle(Minecraft mc, double x, double y, double z, double motionX, double motionY, double motionZ) {
        mc.f_91061_.m_107370_((ParticleOptions)DEParticles.GUARDIAN_PROJECTILE.get(), x, y, z, motionX, motionY, motionZ);
    }

    private static void handleUndyingActivation(Minecraft mc, int id, Item item) {
        if (mc.f_91073_ == null) {
            return;
        }
        Entity entity = mc.f_91073_.m_6815_(id);
        if (entity != null) {
            mc.f_91061_.m_107332_(entity, (ParticleOptions)ParticleTypes.f_123767_, 30);
            if (entity == mc.f_91074_) {
                ((ShieldHudElement)((Object)ClientInit.SHIELD_HUD.get())).popTotem();
            }
        }
    }

    private static void handleBlinkEffect(Minecraft mc, int id, float distance) {
        Entity entity;
        if (mc.f_91073_ == null || (entity = mc.f_91073_.m_6815_(id)) == null) {
            return;
        }
        Vec3 vec = entity.m_20154_();
        Vec3 pos = entity.m_20299_(1.0f);
        for (int i = 0; i < 100; ++i) {
            float offset = mc.f_91073_.f_46441_.m_188501_();
            float speed = (1.0f - offset) * distance;
            speed *= speed;
            Vec3 spawnPos = pos.m_82549_(vec.m_82542_((double)(speed * 10.0f), (double)(speed * 10.0f), (double)(speed * 10.0f)));
            double x = spawnPos.f_82479_ + (mc.f_91073_.f_46441_.m_188583_() - 0.5) * (double)offset;
            double y = spawnPos.f_82480_ + (mc.f_91073_.f_46441_.m_188583_() - 0.5) * (double)offset;
            double z = spawnPos.f_82481_ + (mc.f_91073_.f_46441_.m_188583_() - 0.5) * (double)offset;
            mc.f_91073_.m_7106_((ParticleOptions)DEParticles.BLINK.get(), x, y, z, vec.f_82479_ * (double)speed, vec.f_82480_ * (double)speed, vec.f_82481_ * (double)speed);
        }
    }

    private static void handleStaffEffect(Minecraft mc, MCDataInput data) {
        Entity entity;
        byte type = data.readByte();
        int entityID = data.readVarInt();
        if (mc.f_91073_ != null && (entity = mc.f_91073_.m_6815_(entityID)) instanceof LivingEntity) {
            switch (type) {
                case 0: {
                    DefaultStaffDmgMod.handleEffect((LivingEntity)entity, data);
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
    }

    private static void handleGuardianBeam(Minecraft mc, MCDataInput data) {
        Vector3 source = data.readVector();
        Vector3 target = data.readVector();
        float power = data.readFloat();
        double dist = MathUtils.distance((Vector3)source, (Vector3)target);
        if (mc.f_91073_ == null) {
            return;
        }
        for (double d = 0.0; d < dist; d += 2.0) {
            Vector3 pos = MathUtils.interpolateVec3((Vector3)source, (Vector3)target, (double)((d - 1.0 + mc.f_91073_.f_46441_.m_188500_() * 2.0) / dist));
            mc.f_91073_.m_6493_((ParticleOptions)DEParticles.GUARDIAN_BEAM.get(), true, pos.x, pos.y, pos.z, (double)power, 0.0, 0.0);
        }
    }

    private static void handleGuardianPacket(Minecraft mc, MCDataInput data) {
        if (mc.f_91073_ == null) {
            return;
        }
        Entity e = mc.f_91073_.m_6815_(data.readInt());
        if (!(e instanceof DraconicGuardianEntity)) {
            return;
        }
        DraconicGuardianEntity guardian = (DraconicGuardianEntity)e;
        byte phaseID = data.readByte();
        PhaseManager phaseManager = guardian.getPhaseManager();
        IPhase phase = phaseManager.getCurrentPhase();
        if (phase.getType().getId() != phaseID) {
            return;
        }
        byte function = data.readByte();
        phase.handlePacket(data, function);
    }

    private void handleDislocatorTeleported(Minecraft mc) {
        LocalPlayer player = mc.f_91074_;
        if (player == null) {
            return;
        }
        BlockPos playerPos = player.m_20183_();
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)playerPos.m_7918_(-1, -1, -1), (BlockPos)playerPos.m_7918_(1, 1, 1))) {
            BlockEntity tile = player.m_9236_().m_7702_(pos);
            if (!(tile instanceof TilePortal)) continue;
            ((TilePortal)tile).clientArrived((Player)player);
        }
    }

    private void handleChunkRelight(Minecraft mc, int chunkX, int chunkZ) {
        if (mc.f_91073_ == null) {
            return;
        }
        LevelChunk chunk = mc.f_91073_.m_6325_(chunkX, chunkZ);
        if (chunk != null) {
            // empty if block
        }
    }
}

