/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.inventory;

import codechicken.lib.gui.modular.lib.container.SlotGroup;
import codechicken.lib.inventory.container.modular.ModularSlot;
import codechicken.lib.math.MathHelper;
import com.brandon3055.draconicevolution.blocks.DraconiumBlock;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.inventory.DETileMenu;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class ReactorMenu
extends DETileMenu<TileReactorCore> {
    public final SlotGroup main = this.createSlotGroup(0, new int[0]);
    public final SlotGroup hotBar = this.createSlotGroup(0, new int[0]);
    public final SlotGroup input = this.createSlotGroup(1, new int[0]);
    public final SlotGroup output = this.createSlotGroup(2, new int[0]);

    public ReactorMenu(int windowId, Inventory playerInv, FriendlyByteBuf extraData) {
        this(windowId, playerInv, (TileReactorCore)ReactorMenu.getClientTile((Inventory)playerInv, (FriendlyByteBuf)extraData));
    }

    public ReactorMenu(int windowId, Inventory playerInv, TileReactorCore tile) {
        super((MenuType)DEContent.MENU_REACTOR.get(), windowId, playerInv, tile);
        this.main.addPlayerMain(playerInv);
        this.hotBar.addPlayerBar(playerInv);
        this.input.addSlots(3, 0, e -> new SlotReactor(tile, (int)e));
        this.output.addSlots(3, 0, e -> new SlotReactor(tile, 3 + e));
    }

    @Override
    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
        int maxFuel = 10383;
        int installedFuel = (int)(((TileReactorCore)this.tile).reactableFuel.get() + ((TileReactorCore)this.tile).convertedFuel.get());
        int free = maxFuel - installedFuel;
        Slot slot = this.m_38853_(slotId);
        if (slot instanceof SlotReactor && clickTypeIn == ClickType.PICKUP) {
            ItemStack stackInSlot = slot.m_7993_();
            ItemStack heldStack = player.f_36096_.m_142621_();
            if (!heldStack.m_41619_()) {
                ItemStack copy = heldStack.m_41777_();
                copy.m_41764_(1);
                int value = ReactorMenu.getFuelValue(copy);
                if (value > 0) {
                    int maxInsert = free / value;
                    int insert = Math.min(Math.min(heldStack.m_41613_(), maxInsert), dragType == 1 ? 1 : 64);
                    ((TileReactorCore)this.tile).reactableFuel.add((double)(insert * value));
                    heldStack.m_41774_(insert);
                } else {
                    value = ReactorMenu.getChaosValue(copy);
                    if (value > 0) {
                        int maxInsert = free / value;
                        int insert = Math.min(Math.min(heldStack.m_41613_(), maxInsert), dragType == 1 ? 1 : 64);
                        ((TileReactorCore)this.tile).convertedFuel.add((double)(insert * value));
                        heldStack.m_41774_(insert);
                    }
                }
                if (heldStack.m_41613_() <= 0) {
                    player.f_36096_.m_142503_(ItemStack.f_41583_);
                }
            } else if (!stackInSlot.m_41619_()) {
                ((TileReactorCore)this.tile).reactableFuel.subtract((double)ReactorMenu.getFuelValue(stackInSlot));
                ((TileReactorCore)this.tile).convertedFuel.subtract((double)ReactorMenu.getChaosValue(stackInSlot));
                player.f_36096_.m_142503_(stackInSlot);
            }
        } else if (slotId <= 35) {
            super.m_150399_(slotId, dragType, clickTypeIn, player);
        }
    }

    private static int getFuelValue(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        if (stack.m_41720_() == ((DraconiumBlock)((Object)DEContent.AWAKENED_DRACONIUM_BLOCK.get())).m_5456_()) {
            return stack.m_41613_() * 1296;
        }
        if (stack.m_41720_() == DEContent.INGOT_DRACONIUM_AWAKENED.get()) {
            return stack.m_41613_() * 144;
        }
        if (stack.m_41720_() == DEContent.NUGGET_DRACONIUM_AWAKENED.get()) {
            return stack.m_41613_() * 16;
        }
        return 0;
    }

    private static int getChaosValue(ItemStack stack) {
        if (stack.m_41619_()) {
            return 0;
        }
        if (stack.m_41720_() == DEContent.CHAOS_FRAG_LARGE.get()) {
            return stack.m_41613_() * 1296;
        }
        if (stack.m_41720_() == DEContent.CHAOS_FRAG_MEDIUM.get()) {
            return stack.m_41613_() * 144;
        }
        if (stack.m_41720_() == DEContent.CHAOS_FRAG_SMALL.get()) {
            return stack.m_41613_() * 16;
        }
        return 0;
    }

    public static class SlotReactor
    extends ModularSlot {
        private static Container emptyInventory = new SimpleContainer(6);
        private final TileReactorCore tile;

        public SlotReactor(TileReactorCore tile, int index) {
            super(emptyInventory, index);
            this.tile = tile;
        }

        public void m_40234_(ItemStack before, ItemStack after) {
            int i;
            if (!before.m_41619_() && !after.m_41619_() && before.m_41720_() == after.m_41720_() && (i = after.m_41613_() - before.m_41613_()) > 0) {
                this.m_7169_(before, i);
            }
        }

        public boolean m_5857_(@Nullable ItemStack stack) {
            return false;
        }

        @NotNull
        public ItemStack m_7993_() {
            int index = this.getSlotIndex();
            if (index < 3) {
                int fuel = MathHelper.floor((double)this.tile.reactableFuel.get());
                int block = fuel / 1296;
                int ingot = fuel % 1296 / 144;
                int nugget = fuel % 1296 % 144 / 16;
                if (index == 0 && block > 0) {
                    return new ItemStack((ItemLike)DEContent.AWAKENED_DRACONIUM_BLOCK.get(), block);
                }
                if (index == 1 && ingot > 0) {
                    return new ItemStack((ItemLike)DEContent.INGOT_DRACONIUM_AWAKENED.get(), ingot);
                }
                if (index == 2 && nugget > 0) {
                    return new ItemStack((ItemLike)DEContent.NUGGET_DRACONIUM_AWAKENED.get(), nugget);
                }
            } else {
                int chaos = MathHelper.floor((double)this.tile.convertedFuel.get());
                int block = chaos / 1296;
                int ingot = chaos % 1296 / 144;
                int nugget = chaos % 1296 % 144 / 16;
                if (index == 3 && block > 0) {
                    return new ItemStack((ItemLike)DEContent.CHAOS_FRAG_LARGE.get(), block);
                }
                if (index == 4 && ingot > 0) {
                    return new ItemStack((ItemLike)DEContent.CHAOS_FRAG_MEDIUM.get(), ingot);
                }
                if (index == 5 && nugget > 0) {
                    return new ItemStack((ItemLike)DEContent.CHAOS_FRAG_SMALL.get(), nugget);
                }
            }
            return ItemStack.f_41583_;
        }

        public void m_5852_(@Nonnull ItemStack stack) {
            if (!(this.tile.m_58904_() instanceof ServerLevel)) {
                return;
            }
            int index = this.getSlotIndex();
            if (index < 3) {
                double prevValue = ReactorMenu.getFuelValue(this.m_7993_());
                double newValue = ReactorMenu.getFuelValue(stack);
                double change = newValue - prevValue;
                this.tile.reactableFuel.add(change);
            } else {
                double prevValue = ReactorMenu.getChaosValue(this.m_7993_());
                double newValue = ReactorMenu.getChaosValue(stack);
                double change = newValue - prevValue;
                this.tile.convertedFuel.add(change);
            }
            this.m_6654_();
        }

        public void m_6654_() {
            this.tile.m_6596_();
        }

        public int m_6641_() {
            return 64;
        }

        public ItemStack m_6201_(int amount) {
            return ItemStack.f_41583_;
        }
    }
}

