/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian.control;

import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.control.Phase;
import com.brandon3055.draconicevolution.entity.guardian.control.PhaseType;
import javax.annotation.Nullable;
import net.minecraft.world.phys.Vec3;

public class ApproachPositionPhase
extends Phase {
    private Vec3 targetLocation;
    private PhaseType<?> nextPhase;
    private int startDistance = 0;

    public ApproachPositionPhase(DraconicGuardianEntity guardisn) {
        super(guardisn);
    }

    public PhaseType<ApproachPositionPhase> getType() {
        return PhaseType.APPROACH_POSITION;
    }

    public ApproachPositionPhase setTargetLocation(Vec3 targetLocation) {
        this.targetLocation = targetLocation;
        return this;
    }

    public ApproachPositionPhase setNextPhase(PhaseType<?> nextPhase) {
        this.nextPhase = nextPhase;
        return this;
    }

    @Override
    public void initPhase() {
        this.targetLocation = null;
        this.nextPhase = null;
        this.startDistance = -1;
    }

    @Override
    public void serverTick() {
        double distanceSqr;
        if (this.targetLocation == null || this.nextPhase == null) {
            this.debug("Cancel Approach: (Invalid)");
            this.guardian.getPhaseManager().setPhase(PhaseType.START);
            return;
        }
        if (this.startDistance == -1) {
            this.startDistance = (int)Math.max(Math.sqrt(this.guardian.m_20238_(this.targetLocation)), 32.0);
        }
        if ((distanceSqr = this.targetLocation.m_82531_(this.guardian.m_20185_(), this.guardian.m_20186_(), this.guardian.m_20189_())) > (double)((this.startDistance + 64) * (this.startDistance + 64))) {
            this.debug("Cancel Approach: (Moving away from target)");
            this.guardian.getPhaseManager().setPhase(PhaseType.START);
            return;
        }
        if (distanceSqr < 25.0) {
            this.debug("Approach Complete");
            this.guardian.getPhaseManager().setPhase(this.nextPhase);
        }
    }

    @Override
    @Nullable
    public Vec3 getTargetLocation() {
        return this.targetLocation;
    }

    @Override
    public double getGuardianSpeed() {
        if (this.targetLocation == null) {
            return 1.0;
        }
        double td = this.guardian.m_20238_(this.targetLocation);
        double distMod = td > 1024.0 ? 1.0 : Math.sqrt(td) / 32.0;
        return 0.2 + 2.0 * distMod;
    }

    @Override
    public boolean highVerticalAgility() {
        return true;
    }
}

