/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity.guardian;

import com.brandon3055.draconicevolution.entity.guardian.DraconicGuardianEntity;
import com.brandon3055.draconicevolution.entity.guardian.GuardianFightManager;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DEDamage;
import com.brandon3055.draconicevolution.network.DraconicNetwork;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;

public class GuardianProjectileEntity
extends AbstractHurtingProjectile
implements IEntityAdditionalSpawnData {
    private Vec3 target;
    private double splashRange = 15.0;
    private double power = 10.0;
    private double closestApproach;

    public GuardianProjectileEntity(EntityType<?> type, Level world) {
        super((EntityType)DEContent.ENTITY_GUARDIAN_PROJECTILE.get(), world);
    }

    public GuardianProjectileEntity(Level worldIn, LivingEntity shooter, double accelX, double accelY, double accelZ, Vec3 target, double splashRange, double power) {
        super((EntityType)DEContent.ENTITY_GUARDIAN_PROJECTILE.get(), shooter, accelX, accelY, accelZ, worldIn);
        double accelDotProduct;
        this.target = target;
        this.splashRange = splashRange;
        this.power = power;
        if (target != null) {
            this.closestApproach = this.m_20238_(target);
        }
        if ((accelDotProduct = Math.sqrt(accelX * accelX + accelY * accelY + accelZ * accelZ)) != 0.0) {
            this.f_36813_ = accelX / accelDotProduct * 0.3;
            this.f_36814_ = accelY / accelDotProduct * 0.3;
            this.f_36815_ = accelZ / accelDotProduct * 0.3;
        }
    }

    protected void m_6532_(HitResult result) {
        super.m_6532_(result);
        Entity shooter = this.m_19749_();
        if (!(result.m_6662_() == HitResult.Type.ENTITY && ((EntityHitResult)result).m_82443_().m_7306_(shooter) || this.m_9236_().f_46443_)) {
            this.detonate();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.target != null) {
            double distSq = this.m_20238_(this.target);
            if (distSq <= 1.0) {
                this.detonate();
            } else if (distSq < this.closestApproach) {
                this.closestApproach = distSq;
            } else if (this.f_19797_ > 5) {
                this.detonate();
            }
        }
    }

    private void detonate() {
        GuardianFightManager manager;
        List list = this.m_9236_().m_6443_(LivingEntity.class, this.m_20191_().m_82400_(this.splashRange), EntitySelector.f_20406_);
        Entity shooter = this.m_19749_();
        for (LivingEntity entity : list) {
            double distance;
            double df;
            if (entity == shooter || (df = 1.0 - (distance = (double)entity.m_20270_((Entity)this)) / this.power) <= 0.0) continue;
            float damage = (int)(((df *= (double)Explosion.m_46064_((Vec3)this.m_20182_(), (Entity)entity)) * df + df) / 2.0 * 6.0 * this.power + 1.0);
            entity.m_6469_(DEDamage.guardianProjectile(this.m_9236_(), (Entity)this, shooter), damage);
        }
        boolean destroy = false;
        if (shooter instanceof DraconicGuardianEntity && (manager = ((DraconicGuardianEntity)shooter).getFightManager()) != null && this.m_20183_().m_123342_() > manager.getArenaOrigin().m_123342_() + 20) {
            destroy = true;
        }
        this.m_9236_().m_254849_(shooter, (double)this.m_20183_().m_123341_(), (double)this.m_20183_().m_123342_(), (double)this.m_20183_().m_123343_(), 8.0f, destroy ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
        DraconicNetwork.sendImpactEffect(this.m_9236_(), this.m_20183_(), 0);
        this.m_146870_();
    }

    public boolean m_6087_() {
        return false;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        return false;
    }

    protected ParticleOptions m_5967_() {
        return ParticleTypes.f_123799_;
    }

    protected boolean m_5931_() {
        return false;
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
    }

    public void readSpawnData(FriendlyByteBuf additionalData) {
    }
}

