/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.datagen;

import com.brandon3055.draconicevolution.api.modules.Module;
import com.brandon3055.draconicevolution.api.modules.ModuleRegistry;
import com.brandon3055.draconicevolution.datagen.BlockLootProvider;
import com.brandon3055.draconicevolution.datagen.BlockStateGenerator;
import com.brandon3055.draconicevolution.datagen.BlockTagGenerator;
import com.brandon3055.draconicevolution.datagen.DamageTypeGenerator;
import com.brandon3055.draconicevolution.datagen.DynamicTextures;
import com.brandon3055.draconicevolution.datagen.ItemModelGenerator;
import com.brandon3055.draconicevolution.datagen.LangGenerator;
import com.brandon3055.draconicevolution.datagen.MultiBlockGenerator;
import com.brandon3055.draconicevolution.datagen.RecipeGenerator;
import com.brandon3055.draconicevolution.init.DEContent;
import com.brandon3055.draconicevolution.init.DETags;
import com.brandon3055.draconicevolution.integration.equipment.CuriosIntegration;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.tags.ItemTagsProvider;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class DataGenEventHandler {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        if (event.includeClient()) {
            gen.addProvider(true, (DataProvider)new LangGenerator(gen.getPackOutput()));
            gen.addProvider(true, (DataProvider)new BlockStateGenerator(gen, event.getExistingFileHelper()));
            gen.addProvider(true, (DataProvider)new ItemModelGenerator(gen, event.getExistingFileHelper()));
            gen.addProvider(true, (DataProvider)new MultiBlockGenerator(gen));
            gen.addProvider(true, (DataProvider)new DynamicTextures(gen, event.getExistingFileHelper()));
        }
        if (event.includeServer()) {
            gen.addProvider(true, (DataProvider)new RecipeGenerator(gen.getPackOutput()));
            gen.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(event.getGenerator().getPackOutput(), Set.of(), List.of(new LootTableProvider.SubProviderEntry(BlockLootProvider::new, LootContextParamSets.f_81421_))));
            BlockTagGenerator blockGenerator = new BlockTagGenerator(gen.getPackOutput(), event.getLookupProvider(), "draconicevolution", event.getExistingFileHelper());
            gen.addProvider(true, (DataProvider)blockGenerator);
            gen.addProvider(true, (DataProvider)new ItemTagGenerator(gen.getPackOutput(), event.getLookupProvider(), blockGenerator.m_274426_(), "draconicevolution", event.getExistingFileHelper()));
            gen.addProvider(true, (DataProvider)new DamageTypeGenerator(gen.getPackOutput(), event.getLookupProvider(), "draconicevolution", event.getExistingFileHelper()));
        }
    }

    private static class ItemTagGenerator
    extends ItemTagsProvider {
        public ItemTagGenerator(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pLookupProvider, CompletableFuture<TagsProvider.TagLookup<Block>> pBlockTags, String modId, @Nullable ExistingFileHelper existingFileHelper) {
            super(pOutput, pLookupProvider, pBlockTags, modId, existingFileHelper);
        }

        protected void m_6577_(HolderLookup.Provider pProvider) {
            this.m_206424_(DETags.Items.DUSTS_DRACONIUM).m_255245_((Object)((Item)DEContent.DUST_DRACONIUM.get()));
            this.m_206424_(DETags.Items.DUSTS_DRACONIUM_AWAKENED).m_255245_((Object)((Item)DEContent.DUST_DRACONIUM_AWAKENED.get()));
            this.m_206424_(Tags.Items.DUSTS).addTags(new TagKey[]{DETags.Items.DUSTS_DRACONIUM_AWAKENED, DETags.Items.DUSTS_DRACONIUM});
            this.m_206424_(DETags.Items.NUGGETS_DRACONIUM).m_255245_((Object)((Item)DEContent.NUGGET_DRACONIUM.get()));
            this.m_206424_(DETags.Items.NUGGETS_DRACONIUM_AWAKENED).m_255245_((Object)((Item)DEContent.NUGGET_DRACONIUM_AWAKENED.get()));
            this.m_206424_(Tags.Items.NUGGETS).addTags(new TagKey[]{DETags.Items.NUGGETS_DRACONIUM_AWAKENED, DETags.Items.NUGGETS_DRACONIUM});
            this.m_206424_(DETags.Items.INGOTS_DRACONIUM).m_255245_((Object)((Item)DEContent.INGOT_DRACONIUM.get()));
            this.m_206424_(DETags.Items.INGOTS_DRACONIUM_AWAKENED).m_255245_((Object)((Item)DEContent.INGOT_DRACONIUM_AWAKENED.get()));
            this.m_206424_(Tags.Items.INGOTS).addTags(new TagKey[]{DETags.Items.INGOTS_DRACONIUM_AWAKENED, DETags.Items.INGOTS_DRACONIUM});
            this.m_206424_(DETags.Items.STORAGE_BLOCKS_DRACONIUM).m_255245_((Object)((Item)DEContent.ITEM_DRACONIUM_BLOCK.get()));
            this.m_206424_(DETags.Items.STORAGE_BLOCKS_DRACONIUM_AWAKENED).m_255245_((Object)((Item)DEContent.ITEM_AWAKENED_DRACONIUM_BLOCK.get()));
            this.m_206424_(Tags.Items.STORAGE_BLOCKS).addTags(new TagKey[]{DETags.Items.STORAGE_BLOCKS_DRACONIUM, DETags.Items.STORAGE_BLOCKS_DRACONIUM_AWAKENED});
            this.m_206424_(DETags.Items.ORES_DRACONIUM).m_255179_((Object[])new Item[]{(Item)DEContent.ITEM_END_DRACONIUM_ORE.get(), (Item)DEContent.ITEM_NETHER_DRACONIUM_ORE.get(), (Item)DEContent.ITEM_OVERWORLD_DRACONIUM_ORE.get(), (Item)DEContent.ITEM_DEEPSLATE_DRACONIUM_ORE.get()});
            this.m_206424_(Tags.Items.ORES).m_206428_(DETags.Items.ORES_DRACONIUM);
            for (Module module : ModuleRegistry.getRegistry().getValues()) {
                this.m_206424_(DETags.Items.MODULES).m_255245_((Object)module.getItem());
            }
            if (ModList.get().isLoaded("curios")) {
                CuriosIntegration.generateTags(x$0 -> this.m_206424_((TagKey)x$0));
            }
        }
    }
}

