/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.item;

import codechicken.lib.colour.Colour;
import codechicken.lib.model.PerspectiveModelState;
import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.model.OBJParser;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import com.brandon3055.brandonscore.api.TechLevel;
import com.brandon3055.brandonscore.api.TimeKeeper;
import com.brandon3055.draconicevolution.blocks.energynet.EnergyCrystal;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyCrystal;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class RenderItemEnergyCrystal
implements IItemRenderer {
    public static final RenderType crystalBaseType = RenderType.m_110446_((ResourceLocation)new ResourceLocation("draconicevolution", "textures/models/crystal_base.png"));
    private final EnergyCrystal.CrystalType type;
    private final TechLevel techLevel;
    private final CCModel crystalFull;
    private final CCModel crystalHalf;
    private final CCModel crystalBase;
    private static float[] r = new float[]{0.0f, 0.47f, 1.0f};
    private static float[] g = new float[]{0.2f, 0.0f, 0.4f};
    private static float[] b = new float[]{0.3f, 0.58f, 0.1f};

    public RenderItemEnergyCrystal(EnergyCrystal.CrystalType type, TechLevel techLevel) {
        this.type = type;
        this.techLevel = techLevel;
        Map map = new OBJParser(new ResourceLocation("draconicevolution", "models/block/crystal.obj")).quads().ignoreMtl().parse();
        this.crystalFull = CCModel.combine(map.values()).backfacedCopy();
        map = new OBJParser(new ResourceLocation("draconicevolution", "models/block/crystal_half.obj")).quads().ignoreMtl().parse();
        this.crystalHalf = ((CCModel)map.get("Crystal")).backfacedCopy();
        this.crystalBase = ((CCModel)map.get("Base")).backfacedCopy();
    }

    public boolean m_7541_() {
        return false;
    }

    public boolean m_7539_() {
        return false;
    }

    public boolean m_7547_() {
        return false;
    }

    public void renderItem(ItemStack stack, ItemDisplayContext context, PoseStack mStack, MultiBufferSource getter, int packedLight, int packedOverlay) {
        int tier = this.techLevel.index;
        Matrix4 mat = new Matrix4(mStack);
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.reset();
        ccrs.brightness = packedLight;
        ccrs.overlay = packedOverlay;
        mat.translate(0.5, this.type == EnergyCrystal.CrystalType.CRYSTAL_IO ? 0.0 : 0.5, 0.5);
        DEShaders.energyCrystalMipmap.glUniform1f(0.0f);
        DEShaders.energyCrystalColour.glUniform3f(RenderTileEnergyCrystal.COLOURS[tier][0], RenderTileEnergyCrystal.COLOURS[tier][1], RenderTileEnergyCrystal.COLOURS[tier][2]);
        if (this.type == EnergyCrystal.CrystalType.CRYSTAL_IO) {
            ccrs.bind(crystalBaseType, getter);
            this.crystalBase.render(ccrs, new IVertexOperation[]{mat});
            mat.apply((Transformation)new Rotation((double)((float)TimeKeeper.getClientTick() / 400.0f), 0.0, 1.0, 0.0));
            ccrs.baseColour = Colour.packRGBA((double)r[tier], (double)g[tier], (double)b[tier], (double)1.0);
            ccrs.bind(RenderTileEnergyCrystal.crystalType, getter);
            this.crystalHalf.render(ccrs, new IVertexOperation[]{mat});
        } else {
            ccrs.baseColour = Colour.packRGBA((double)r[tier], (double)g[tier], (double)b[tier], (double)1.0);
            mat.apply((Transformation)new Rotation((double)((float)TimeKeeper.getClientTick() / 400.0f), 0.0, 1.0, 0.0));
            ccrs.bind(RenderTileEnergyCrystal.crystalType, getter);
            this.crystalFull.render(ccrs, new IVertexOperation[]{mat});
        }
    }

    @Nullable
    public PerspectiveModelState getModelState() {
        return TransformUtils.DEFAULT_BLOCK;
    }
}

