/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.entity;

import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.client.DEShaders;
import com.brandon3055.draconicevolution.client.render.entity.DraconicGuardianRenderer;
import com.brandon3055.draconicevolution.entity.GuardianCrystalEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class GuardianCrystalRenderer
extends EntityRenderer<GuardianCrystalEntity> {
    private static ResourceLocation ENDER_CRYSTAL_TEXTURES = new ResourceLocation("draconicevolution", "textures/entity/guardian_crystal.png");
    private static RenderType RENDER_TYPE = RenderType.m_110458_((ResourceLocation)ENDER_CRYSTAL_TEXTURES);
    private static final float SIN_45 = (float)Math.sin(0.7853981633974483);
    private final ModelPart cube;
    private final ModelPart glass;
    private final ModelPart base;

    public GuardianCrystalRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.f_114477_ = 0.5f;
        ModelPart modelpart = context.m_174023_(ModelLayers.f_171145_);
        this.glass = modelpart.m_171324_("glass");
        this.cube = modelpart.m_171324_("cube");
        this.base = modelpart.m_171324_("base");
    }

    public void render(GuardianCrystalEntity crystal, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffers, int packedLight) {
        BlockPos blockpos;
        poseStack.m_85836_();
        float yBob = GuardianCrystalRenderer.getY(crystal, partialTicks);
        float anim = ((float)crystal.time + partialTicks) * 3.0f;
        VertexConsumer vertexconsumer = buffers.m_6299_(RENDER_TYPE);
        poseStack.m_85841_(2.0f, 2.0f, 2.0f);
        poseStack.m_85837_(0.0, -0.5, 0.0);
        int overlayTex = OverlayTexture.f_118083_;
        if (crystal.showsBottom()) {
            this.base.m_104301_(poseStack, vertexconsumer, packedLight, overlayTex);
        }
        poseStack.m_252781_(Axis.f_252436_.m_252977_(anim));
        poseStack.m_85837_(0.0, (double)(1.5f + yBob / 2.0f), 0.0);
        poseStack.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        this.glass.m_104301_(poseStack, vertexconsumer, packedLight, overlayTex);
        float scale = 0.875f;
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(anim));
        this.glass.m_104301_(poseStack, vertexconsumer, packedLight, overlayTex);
        poseStack.m_85841_(scale, scale, scale);
        poseStack.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(anim));
        this.cube.m_104301_(poseStack, vertexconsumer, packedLight, overlayTex);
        poseStack.m_85849_();
        float shieldPower = crystal.getShieldPower() / (float)Math.max(20, DEConfig.guardianCrystalShield);
        if (shieldPower > 0.0f) {
            DEShaders.shieldBarMode.glUniform1i(0);
            DEShaders.shieldColour.glUniform4f(1.0f, 0.0f, 0.0f, 1.5f * shieldPower);
            DEShaders.shieldActivation.glUniform1f(1.0f);
            VertexConsumer shaderBuilder = buffers.m_6299_(DraconicGuardianRenderer.SHIELD_TYPE);
            poseStack.m_85836_();
            poseStack.m_85841_(2.0f, 2.0f, 2.0f);
            poseStack.m_85837_(0.0, -0.5, 0.0);
            if (crystal.showsBottom()) {
                this.base.m_104301_(poseStack, shaderBuilder, packedLight, overlayTex);
            }
            poseStack.m_252781_(Axis.f_252436_.m_252977_(anim));
            poseStack.m_85837_(0.0, (double)(1.5f + yBob / 2.0f), 0.0);
            poseStack.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
            this.glass.m_104301_(poseStack, shaderBuilder, packedLight, overlayTex);
            poseStack.m_85841_(scale, scale, scale);
            poseStack.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(anim));
            this.glass.m_104301_(poseStack, shaderBuilder, packedLight, overlayTex);
            poseStack.m_85841_(scale, scale, scale);
            poseStack.m_252781_(new Quaternionf().setAngleAxis(1.0471976f, SIN_45, 0.0f, SIN_45));
            poseStack.m_252781_(Axis.f_252436_.m_252977_(anim));
            this.cube.m_104301_(poseStack, shaderBuilder, packedLight, overlayTex);
            poseStack.m_85849_();
        }
        if ((blockpos = crystal.getBeamTarget()) != null) {
            float targetX = (float)blockpos.m_123341_() + 0.5f;
            float targetY = (float)blockpos.m_123342_() + 0.5f;
            float targetZ = (float)blockpos.m_123343_() + 0.5f;
            float xRel = (float)((double)targetX - crystal.m_20185_());
            float yRel = (float)((double)targetY - crystal.m_20186_());
            float zRel = (float)((double)targetZ - crystal.m_20189_());
            poseStack.m_252880_(xRel, yRel - 2.0f, zRel);
            float beamPower = crystal.getBeamPower();
            if (beamPower < 1.0f) {
                DraconicGuardianRenderer.renderBeam(-xRel, -yRel + yBob + 2.0f, -zRel, partialTicks, crystal.time, poseStack, buffers, packedLight, beamPower);
            } else {
                DraconicGuardianRenderer.renderBeam(-xRel, -yRel + yBob + 2.0f, -zRel, partialTicks, crystal.time, poseStack, buffers, packedLight);
            }
        }
        super.m_7392_((Entity)crystal, entityYaw, partialTicks, poseStack, buffers, packedLight);
    }

    public static float getY(GuardianCrystalEntity crystal, float partialTicks) {
        float f = (float)crystal.time + partialTicks;
        float f1 = Mth.m_14031_((float)(f * 0.2f)) / 2.0f + 0.5f;
        f1 = (f1 * f1 + f1) * 0.4f;
        return f1 - 1.4f;
    }

    public ResourceLocation getTextureLocation(GuardianCrystalEntity entity) {
        return ENDER_CRYSTAL_TEXTURES;
    }

    public boolean shouldRender(GuardianCrystalEntity entity, Frustum camera, double camX, double camY, double camZ) {
        return super.m_5523_((Entity)entity, camera, camX, camY, camZ) || entity.getBeamTarget() != null;
    }
}

