/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.config;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import com.brandon3055.draconicevolution.api.config.ConfigProperty;
import com.brandon3055.draconicevolution.client.gui.modular.itemconfig.PropertyData;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class BooleanProperty
extends ConfigProperty {
    private boolean value;
    private boolean defaultValue;
    private ConfigProperty.BooleanFormatter formatter = ConfigProperty.BooleanFormatter.TRUE_FALSE;
    private Supplier<Boolean> valueOverride;
    private BiConsumer<ItemStack, BooleanProperty> changeListener;

    public BooleanProperty(String name, boolean defaultValue) {
        super(name);
        this.value = this.defaultValue = defaultValue;
    }

    public BooleanProperty(String name, Component displayName, boolean defaultValue) {
        super(name, displayName);
        this.value = this.defaultValue = defaultValue;
    }

    public boolean getValue() {
        return this.valueOverride == null ? this.value : this.valueOverride.get();
    }

    public void setValue(boolean value) {
        this.value = value;
    }

    public void setValueOverride(Supplier<Boolean> valueOverride) {
        this.valueOverride = valueOverride;
    }

    @Override
    public String getDisplayValue() {
        return this.formatter.format(this.getValue());
    }

    public BooleanProperty setFormatter(ConfigProperty.BooleanFormatter formatter) {
        this.formatter = formatter;
        return this;
    }

    public ConfigProperty.BooleanFormatter getFormatter() {
        return this.formatter;
    }

    @Override
    public void onValueChanged(ItemStack stack) {
        if (this.changeListener != null) {
            this.changeListener.accept(stack, this);
        }
    }

    @Override
    public void validateValue() {
    }

    @Override
    public ConfigProperty.Type getType() {
        return ConfigProperty.Type.BOOLEAN;
    }

    public void setChangeListener(Runnable changeListener) {
        this.changeListener = (stack, t) -> changeListener.run();
    }

    public void setChangeListener(Consumer<ItemStack> changeListener) {
        this.changeListener = (stack, booleanProperty) -> changeListener.accept((ItemStack)stack);
    }

    public void setChangeListener(BiConsumer<ItemStack, BooleanProperty> changeListener) {
        this.changeListener = changeListener;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        if (this.value != this.defaultValue) {
            nbt.m_128379_("value", this.value);
        }
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        if (nbt.m_128441_("value")) {
            this.value = nbt.m_128471_("value");
        }
        super.deserializeNBT(nbt);
    }

    @Override
    public void serializeMCData(MCDataOutput output) {
        super.serializeMCData(output);
        output.writeBoolean(this.value);
    }

    @Override
    public void deSerializeMCData(MCDataInput input) {
        super.deSerializeMCData(input);
        this.value = input.readBoolean();
    }

    @Override
    public void loadData(PropertyData data, ItemStack stack) {
        this.value = data.booleanValue;
        this.onValueChanged(stack);
    }
}

