/*
 * Decompiled with CFR 0.152.
 */
package net.gigabit101.rebornstorage.nodes;

import com.refinedmods.refinedstorage.api.network.INetworkNodeVisitor;
import com.refinedmods.refinedstorage.api.network.IWirelessTransmitter;
import com.refinedmods.refinedstorage.api.network.node.INetworkNode;
import com.refinedmods.refinedstorage.apiimpl.network.node.NetworkNode;
import com.refinedmods.refinedstorage.inventory.item.BaseItemHandler;
import com.refinedmods.refinedstorage.inventory.item.UpgradeItemHandler;
import com.refinedmods.refinedstorage.inventory.listener.InventoryListener;
import com.refinedmods.refinedstorage.inventory.listener.NetworkNodeInventoryListener;
import com.refinedmods.refinedstorage.item.UpgradeItem;
import com.refinedmods.refinedstorage.util.StackUtils;
import net.gigabit101.rebornstorage.RebornStorageConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class AdvancedWirelessTransmitterNode
extends NetworkNode
implements IWirelessTransmitter {
    public static final ResourceLocation ID = new ResourceLocation("rebornstorage", "advanced_wireless_transmitter");
    private final UpgradeItemHandler upgrades = (UpgradeItemHandler)new UpgradeItemHandler(4, new UpgradeItem.Type[]{UpgradeItem.Type.RANGE}).addListener((InventoryListener)new NetworkNodeInventoryListener((INetworkNode)this));

    public AdvancedWirelessTransmitterNode(Level level, BlockPos pos) {
        super(level, pos);
    }

    public int getRange() {
        return (Integer)RebornStorageConfig.ADVANCED_WIRELESS_TRANSMITTER_RANGE.get() + this.upgrades.getUpgradeCount(UpgradeItem.Type.RANGE) * (Integer)RebornStorageConfig.ADVANCED_WIRELESS_RAGE_BOOSTER_RANGE.get();
    }

    public BlockPos getOrigin() {
        return this.pos;
    }

    public ResourceKey<Level> getDimension() {
        return this.level.m_46472_();
    }

    public int getEnergyUsage() {
        return (Integer)RebornStorageConfig.ADVANCED_WIRELESS_TRANSMITTER_POWER_COST.get();
    }

    public boolean canConduct(Direction direction) {
        return this.getDirection() == direction;
    }

    public void visit(INetworkNodeVisitor.Operator operator) {
        operator.apply(this.level, this.pos.m_121945_(Direction.DOWN), Direction.UP);
    }

    public ResourceLocation getId() {
        return ID;
    }

    public void read(CompoundTag tag) {
        super.read(tag);
        StackUtils.readItems((BaseItemHandler)this.upgrades, (int)0, (CompoundTag)tag);
    }

    public CompoundTag write(CompoundTag tag) {
        super.write(tag);
        StackUtils.writeItems((IItemHandler)this.upgrades, (int)0, (CompoundTag)tag);
        return tag;
    }

    public UpgradeItemHandler getUpgrades() {
        return this.upgrades;
    }

    @Nullable
    public IItemHandler getDrops() {
        return this.getUpgrades();
    }
}

